// Pipe_control_point.hpp
//
// Copyright 2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Pipe control point class, used to specify control points for the Pipe class

#ifndef TOVERO_MATH_PIPE_CONTROL_POINT_HPP_
#define TOVERO_MATH_PIPE_CONTROL_POINT_HPP_

#include <tovero/math/geometry/Distance.hpp>
#include <tovero/math/geometry/Point.hpp>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class Geometric_tolerances;

    class Pipe_control_point
    {
    public:
      // constructors
      Pipe_control_point();
      Pipe_control_point(Point position,
                         Distance inner_radius,
                         Distance outer_radius,
                         Distance bend_radius);
      //   Note: let compiler generate copy constructor, operator=, and destructor
      // accessors/mutators
      Point position() const { return m_position; }
      void set_position(Point position) { m_position = position; }
      Distance inner_radius() const { return m_inner_radius; }
      void set_inner_radius(Distance radius) { m_inner_radius = radius; }
      Distance outer_radius() const { return m_outer_radius; }
      void set_outer_radius(Distance radius) { m_outer_radius = radius; }
      Distance bend_radius() const { return m_bend_radius; }
      void set_bend_radius(Distance radius) { m_bend_radius = radius; }
      // predicates
      //draft started here... TO DO: Make Pipe_control_point be able to check its own validity
      //virtual bool is_valid(const Geometric_tolerances& tolerances,
      //                      Roan_trail::Tovero_support::Error_param& return_error) const;
    private:
      Point m_position;
      Distance m_inner_radius;
      Distance m_outer_radius;
      Distance m_bend_radius;
    };
  }
}

#endif // TOVERO_MATH_PIPE_CONTROL_POINT_HPP_
