// Solid_combination.hpp
//
// Copyright 2012-2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// General class used to group a series of solid operations.  The
// Union operation has the least precedence, and is used for
// grouping.  Note that you may have to use additional
// Solid_combination (or Solid_operation) nodes to achieve a particular
// grouping.  The first node is interpreted as Unioned in,
// without regard to its actual stored operation.

// TODO: check BRL-CAD to see if first node is in fact
//       Unioned in as stated.

#ifndef TOVERO_MATH_SOLID_COMBINATION_HPP_
#define TOVERO_MATH_SOLID_COMBINATION_HPP_

#include <tovero/math/geometry/Solid_combination_base.hpp>
#include <tovero/support/Reference_counting_list.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Solid_member;

    class Solid_combination : public Solid_combination_base
    {
    public:
      // constructor/copy
      //   Note: list members referenced, not const in list:
      Solid_combination(const Roan_trail::Tovero_support::Reference_counting_list<Solid_member>& members
                        = Roan_trail::Tovero_support::Reference_counting_list<Solid_member>(),
                        const std::string& name = "");
      Solid_combination(const std::string& name);
      Solid_combination(const Solid_combination& c);
      Solid_combination& operator=(const Solid_combination& c);
      virtual Solid* clone_solid() const { return new Solid_combination(*this); }
      // accessors/mutators
      //   Note: members referenced, not const in list:
      const Roan_trail::Tovero_support::Reference_counting_list<Solid_member>& members() const
      { return m_members; }
      Roan_trail::Tovero_support::Reference_counting_list<Solid_member>& members() { return m_members; }
      // operators
      inline Solid_combination& operator<<(Solid_member& member);
      inline Solid_combination& operator<<(Solid& member);
      // functions
      void add_member(Solid_member& member);
      void add_member(Solid& member);
      virtual bool is_primitive() const { return false; }
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const;
      // other
      virtual std::string solid_class() const { return "Solid_combination"; }
    protected:
      // destructor
      virtual ~Solid_combination() {}
    private:
      Roan_trail::Tovero_support::Reference_counting_list<Solid_member> m_members;
    };

    // operators
    inline Solid_combination& Solid_combination::operator<<(Solid_member& member)
    {
      add_member(member);

      return *this;
    }

    inline Solid_combination& Solid_combination::operator<<(Solid& member)
    {
      add_member(member);

      return *this;
    }
  }
}

#endif // TOVERO_MATH_SOLID_COMBINATION_HPP_
