// Solid_visitor.hpp
//
// Copyright 2012-2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Visitor for solid classes (GOF Visitor Pattern)

#ifndef TOVERO_MATH_SOLID_VISITOR_HPP_
#define TOVERO_MATH_SOLID_VISITOR_HPP_

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Axis_aligned_box;
    class Boundary_triangle_mesh;
    class Box;
    class Cone;
    class Cylinder;
    class Ellipsoid;
    class Ellipsoid_base;
    class Elliptical_cone;
    class Elliptical_cylinder;
    class General_cone;
    class Half_space;
    class Oblique_cone;
    class Oblique_cylinder;
    class Pipe;
    class Plate_triangle_mesh;
    class Polyhedron;
    class Solid_operation;
    class Solid_combination;
    class Sphere;
    class Torus;
    class Triangle_mesh;
    class General_cone;
    class Wedge;

    class Solid_visitor
    {
    public:
      // enum
      enum Visit_result
        {
          abort = 0,
          success
          // prune
        };
      // visit member functions (virtual, default to doing nothing)
      // TODO: versions with non-const parameters, for traversals which modify nodes
      //   composites
      virtual Visit_result visit_enter(const Solid_operation& operation) { return success; }
      virtual Visit_result visit_exit(const Solid_operation& operation) { return success; }
      virtual Visit_result visit_enter(const Solid_combination& combination) { return success; }
      virtual Visit_result visit_exit(const Solid_combination& combination) { return success; }
      //   leaf (primitives)
      virtual Visit_result visit(const Axis_aligned_box& box) { return success; }
      virtual Visit_result visit(const Boundary_triangle_mesh& mesh) { return success; }
      virtual Visit_result visit(const Box& box) { return success; }
      virtual Visit_result visit(const Cone& cone) { return success; }
      virtual Visit_result visit(const Cylinder& cylinder) { return success; }
      virtual Visit_result visit(const Ellipsoid& ellipsoid) { return success; }
      virtual Visit_result visit(const Elliptical_cone& cone) { return success; }
      virtual Visit_result visit(const Elliptical_cylinder& cylinder) { return success; }
      virtual Visit_result visit(const General_cone& cone) { return success; }
      virtual Visit_result visit(const Half_space& space) { return success; }
      virtual Visit_result visit(const Oblique_cone& cylinder) { return success; }
      virtual Visit_result visit(const Oblique_cylinder& cylinder) { return success; }
      virtual Visit_result visit(const Pipe& pipe) { return success; }
      virtual Visit_result visit(const Plate_triangle_mesh& mesh) { return success; }
      virtual Visit_result visit(const Polyhedron& polyhedron) { return success; }
      virtual Visit_result visit(const Sphere& sphere) { return success; }
      virtual Visit_result visit(const Torus& torus) { return success; }
      virtual Visit_result visit(const Triangle_mesh& mesh) { return success; }
      virtual Visit_result visit(const Wedge& wedge) { return success; }
    protected:
      // destructor
      virtual ~Solid_visitor() {}
    };
  }
}

#endif // TOVERO_MATH_SOLID_VISITOR_HPP_
