// Triangle_mesh.hpp
//
// Copyright 2012-2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Triangle mesh solid

#ifndef TOVERO_MATH_TRIANGLE_MESH_HPP_
#define TOVERO_MATH_TRIANGLE_MESH_HPP_

#include <tovero/math/geometry/Solid.hpp>
#include <tovero/math/geometry/Triangle_face.hpp>
#include <string>
#include <vector>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class Geometric_tolerances;
    class Point;
    class Vector;
    class Unit_vector;

    class Triangle_mesh : public Solid
    {
    public:
      // constructors/copy
      Triangle_mesh(Triangle_face::Triangle_direction_type triangle_direction,
                    const std::vector<Point>& vertices,
                    const std::vector<Triangle_face>& faces,
                    const std::vector<Unit_vector>& normals,
                    const std::vector<Triangle_face>& face_normals,
                    bool has_surface_normals,
                    bool use_surface_normals,
                    const std::string& name = "");
      virtual Solid* clone_solid() const { return new Triangle_mesh(*this); }
      //   Note: let compiler generate copy constructor and operator=
      // accessors//mutators
      Triangle_face::Triangle_direction_type triangle_direction() const { return m_triangle_direction; }
      void set_triangle_direction(Triangle_face::Triangle_direction_type direction)
      { m_triangle_direction = direction; }
      const std::vector<Point>& vertices() const { return m_vertices; }
      std::vector<Point>& vertices() { return m_vertices; }
      const std::vector<Triangle_face>& faces() const { return m_faces; }
      std::vector<Triangle_face>& faces() { return m_faces; }
      const std::vector<Unit_vector>& normals() const { return m_normals; }
      std::vector<Unit_vector>& normals() { return m_normals; }
      const std::vector<Triangle_face>& face_normals() const { return m_face_normals; }
      std::vector<Triangle_face>& face_normals() { return m_face_normals; }
      bool has_surface_normals() const { return m_has_surface_normals; }
      void set_has_surface_normals(bool has_surface_normals) { m_has_surface_normals = has_surface_normals; }
      bool use_surface_normals() const { return m_use_surface_normals; }
      void set_use_surface_normals(bool use_surface_normals) { m_use_surface_normals = use_surface_normals; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Triangle_mesh"; }
    protected:
      // destructor
      virtual ~Triangle_mesh() {}
    private:
      // solid parameters
      Triangle_face::Triangle_direction_type m_triangle_direction;
      std::vector<Point> m_vertices;
      std::vector<Triangle_face> m_faces;
      std::vector<Unit_vector> m_normals;
      std::vector<Triangle_face> m_face_normals;
      bool m_has_surface_normals;
      bool m_use_surface_normals;
    };
  }
}

#endif // TOVERO_MATH_TRIANGLE_MESH_HPP_
