// Units_mapper.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_MATH_UNITS_MAPPER_HPP_
#define TOVERO_MATH_UNITS_MAPPER_HPP_

#include <map>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Angle;
    class Area;
    class Distance;

    class Units_mapper
    {
    public:
      // typedefs
      typedef std::map<std::string, Distance> Length_map_type;
      typedef std::map<std::string, Area> Area_map_type;
      typedef std::map<std::string, Angle> Angle_map_type;
      // constructor
      Units_mapper();
      // accessors/mutators
      const std::string& length_units() const { return m_length_units; }
      bool set_length_units(const std::string& length_units);
      const std::string& area_units() const { return m_area_units; }
      bool set_area_units(const std::string& area_units);
      const std::string& angle_units() const { return m_angle_units; }
      bool set_angle_units(const std::string& angle_units);
      // class data members
      static Length_map_type length_map;
      static Area_map_type area_map;
      static Angle_map_type angle_map;
    private:
      std::string m_length_units;
      std::string m_area_units;
      std::string m_angle_units;
    };
  }
}

#endif // TOVERO_MATH_UNITS_MAPPER_HPP_
