# test_cone.rb
#
# Copyright 2012-2014 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.

# Ruby unit test (minitest) for the Cone class

require 'minitest/autorun'
require 'test/unit'
require 'libtovero_support_rb_1'
require 'libtovero_math_rb_1'

include Libtovero_support_rb_1
include Libtovero_math_rb_1

class TestCone < Test::Unit::TestCase
  def setup
    @Tolerances = GeometricTolerances.new
  end

  #
  # Solid validity checks
  #

  def test_default
    cone = Cone.new
    error = ErrorParam.new
    #
    assert cone.is_valid?(@Tolerances, error)
  end

  def test_zero_length_height
    cone = Cone.new
    cone.name = "cone"
    zero_length_vector = Vector.new
    cone.height = zero_length_vector
    error = ErrorParam.new
    #
    refute cone.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_negative_base_radius
    cone = Cone.new
    cone.base_radius = Distance.new(-1.0, Distance::meter);
    error = ErrorParam.new
    #
    refute cone.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_zero_top_radius
    cone = Cone.new
    cone.top_radius = Distance.new(0.0, Distance::meter);
    error = ErrorParam.new
    #
    refute cone.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  #
  # Miscellaneous checks
  #

  def test_properties
    cone = Cone.new
    #
    assert_respond_to cone, :base
    assert_respond_to cone, :base=
    assert_respond_to cone, :height
    assert_respond_to cone, :height=
    assert_respond_to cone, :base_radius
    assert_respond_to cone, :base_radius=
    assert_respond_to cone, :top_radius
    assert_respond_to cone, :top_radius=
  end

end
