# test_ellipsoid.rb
#
# Copyright 2012-2014 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.

# Ruby unit test (minitest) for the Ellipsoid class

require 'minitest/autorun'
require 'test/unit'
require 'libtovero_support_rb_1'
require 'libtovero_math_rb_1'

include Libtovero_support_rb_1
include Libtovero_math_rb_1

class TestEllipsoid < Test::Unit::TestCase
  def setup
    @Tolerances = GeometricTolerances.new
  end

  #
  # Solid validity checks
  #

  def test_default
    ellipsoid = Ellipsoid.new
    error = ErrorParam.new
    #
    assert ellipsoid.is_valid?(@Tolerances, error)
  end

  def test_zero_axis_length
    ellipsoid = Ellipsoid.new
    ellipsoid.name = "ellipsoid"
    zero_length_vector = Vector.new
    ellipsoid.axis_c = zero_length_vector
    error = ErrorParam.new
    #
    refute ellipsoid.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_not_mutually_perpendicular_axes
    ellipsoid = Ellipsoid.new
    ellipsoid.axis_a = UnitVector::z * Distance.new(1.0, Distance::meter)
    ellipsoid.axis_b = UnitVector::y * Distance.new(1.0, Distance::meter)
    ellipsoid.axis_c = UnitVector::z * Distance.new(1.0, Distance::meter)
    error = ErrorParam.new
    #
    refute ellipsoid.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  #
  # Miscellaneous checks
  #

  def test_properties
    ellipsoid = Ellipsoid.new
    #
    assert_respond_to ellipsoid, :center
    assert_respond_to ellipsoid, :center=
    assert_respond_to ellipsoid, :axis_a
    assert_respond_to ellipsoid, :axis_a=
    assert_respond_to ellipsoid, :axis_b
    assert_respond_to ellipsoid, :axis_b=
    assert_respond_to ellipsoid, :axis_c
    assert_respond_to ellipsoid, :axis_c=
  end

end
