# test_polyhedron.rb
#
# Copyright 2012-2014 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.

# Ruby unit test (minitest) for the Polyhedron class

require 'minitest/autorun'
require 'test/unit'
require 'libtovero_support_rb_1'
require 'libtovero_math_rb_1'

include Libtovero_support_rb_1
include Libtovero_math_rb_1

class TestPolyhedron < Test::Unit::TestCase
  def setup
    @Tolerances = GeometricTolerances.new
  end

  #
  # Solid validity checks
  #

  def test_default
    polyhedron = Polyhedron.new
    error = ErrorParam.new
    #
    assert polyhedron.is_valid?(@Tolerances, error)
  end

  def test_too_many_vertices
    polyhedron = Polyhedron.new
    vertices = polyhedron.vertices
    vertices << Point.new
    error = ErrorParam.new
    #
    refute polyhedron.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_no_vertices
    polyhedron = Polyhedron.new
    vertices = polyhedron.vertices
    vertices.clear
    error = ErrorParam.new
    #
    refute polyhedron.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_bad_face
    skip
    # TODO: implement
  end

  def test_too_few_faces
    skip
    # TODO: implement
  end

  #
  # Miscellaneous checks
  #

  def test_properties
    polyhedron = Polyhedron.new
    #
    assert_respond_to polyhedron, :vertices
  end

end
