# test_sphere.rb
#
# Copyright 2012-2014 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.

# Ruby unit test (minitest) for the Sphere class

require 'minitest/autorun'
require 'test/unit'
require 'libtovero_support_rb_1'
require 'libtovero_math_rb_1'

include Libtovero_support_rb_1
include Libtovero_math_rb_1

class TestSphere < Test::Unit::TestCase
  def setup
    @Tolerances = GeometricTolerances.new
  end

  #
  # Solid validity checks
  #

  def test_default
    sphere = Sphere.new
    error = ErrorParam.new
    #
    assert sphere.is_valid?(@Tolerances, error)
  end

  def test_negative_radius
    sphere = Sphere.new
    sphere.name = "sphere"
    sphere.radius = Distance.new(-1.0, Distance::meter)
    error = ErrorParam.new
    #
    refute sphere.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  #
  # Miscellaneous checks
  #

  def test_properties
    sphere = Sphere.new
    #
    assert_respond_to sphere, :center
    assert_respond_to sphere, :center=
    assert_respond_to sphere, :radius
    assert_respond_to sphere, :radius=
  end

end
