# test_wedge.rb
#
# Copyright 2012-2014 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.

# Ruby unit test (minitest) for the Wedge class

require 'minitest/autorun'
require 'test/unit'
require 'libtovero_support_rb_1'
require 'libtovero_math_rb_1'

include Libtovero_support_rb_1
include Libtovero_math_rb_1

class TestWedge < Test::Unit::TestCase
  def setup
    @Tolerances = GeometricTolerances.new
  end

  #
  # Solid validity checks
  #

  def test_default
    wedge = Wedge.new
    error = ErrorParam.new
    #
    assert wedge.is_valid?(@Tolerances, error)
  end

  def test_zero_length_dimension
    wedge = Wedge.new
    wedge.name = "wedge"
    zero_length_vector = Vector.new
    wedge.height = zero_length_vector
    error = ErrorParam.new
    #
    refute wedge.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_direction_vectors_not_mutually_perpendicular
    wedge = Wedge.new
    wedge.height = UnitVector::x * Distance.new(1.0, Distance::meter)
    wedge.width = UnitVector::y * Distance.new(1.0, Distance::meter)
    wedge.depth = UnitVector::y * Distance.new(1.0, Distance::meter)
    error = ErrorParam.new
    #
    refute wedge.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  #
  # Miscellaneous checks
  #

  def test_properties
    wedge = Wedge.new
    #
    assert_respond_to wedge, :vertex
    assert_respond_to wedge, :vertex=
    assert_respond_to wedge, :width
    assert_respond_to wedge, :width=
    assert_respond_to wedge, :height
    assert_respond_to wedge, :height=
    assert_respond_to wedge, :depth
    assert_respond_to wedge, :depth=
  end

end
