// Graphics_error.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_SUPPORT_GRAPHICS_ERROR_HPP_
#define TOVERO_SUPPORT_GRAPHICS_ERROR_HPP_

#include <tovero/support/error/Error.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Graphics_error : public Error
    {
    public:
      // enum
      //   error codes
      enum Graphics_error_code
        {
          none        =  0, // code for none should always be 0
          general,          // code for general error should always be 1
          read,
          write,
          database,
          validation
        };

      // constructor/destructor/copy/clone
      Graphics_error(const char* file,
                const char* function,
                int line,
                int code,
                const Error* base_error = 0);
      Graphics_error(const char* file,
                const char* function,
                int line,
                int code,
                const std::string& diagnostic,
                const std::string& file_path = "",
                const Error* base_error = 0);
      virtual Graphics_error* clone() const { return new Graphics_error(*this); }
      // error keys
      static const std::string database_node_name_error_key;
      // other
      virtual std::string error_class() const { return "Graphics_error"; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Graphics_error operator=(const Graphics_error& e);
    };
  }
}

#endif // TOVERO_SUPPORT_GRAPHICS_ERROR_HPP_
