// Math_error.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_SUPPORT_MATH_ERROR_HPP_
#define TOVERO_SUPPORT_MATH_ERROR_HPP_

#include <tovero/support/error/Error.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Math_error : public Error
    {
    public:
      // enum
      //   error codes
      enum Math_error_code
        {
          none       =  0, // code for none should always be 0
          general,         // code for general error should always be 1
          validation
        };
      // constructor/destructor/copy/clone
      Math_error(const char* file,
                 const char* function,
                 int line,
                 int code,
                 const Error* base_error = 0);
      Math_error(const char* file,
                 const char* function,
                 int line,
                 int code,
                 const std::string& diagnostic,
                 const Error* base_error = 0);
      virtual Math_error* clone() const { return new Math_error(*this); }
      // other
      virtual std::string error_class() const { return "Math_error"; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Math_error operator=(const Math_error& e);
    };
  }
}

#endif // TOVERO_SUPPORT_MATH_ERROR_HPP_
