// -*- C++ -*-
//
// support.i
//
// Copyright 2012-2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// SWIG interface file for the Tovero support library
// Notes:
//   %include <file> generates wrapper code for file
//   %import <file> just reads declarations, and does not generate wrapper code

%module "libtovero_support_rb_1"

// Note: code between the %{ %} brackets is copied verbatim to the wrapper file
%{
  #include "common.hpp"
  #include <sstream>
  #include "error/Error.hpp"
  #include "error/Graphics_error.hpp"
  #include "Logger.hpp"
  #include "error/Math_error.hpp"
  #include "Reference_counting_base.hpp"
  #include "Reference_counting_list.hpp"
  #include "Reference_counting_map.hpp"

  using std::ostringstream;
  using Roan_trail::Tovero_support::Long_int;
%}

//
// SWIG macros
//

%define extend_str(Class)
  %extend Class
  {
    const char *__str__()
    {
      ostringstream s;
      s << *$self;
      return s.str().c_str();
    }
  }
%enddef

//
// Ruby-specific interface
//

#ifdef SWIGRUBY

%ignore Roan_trail::Tovero_support::Error::operator=;
%ignore Roan_trail::Tovero_support::Error::operator!=;
%ignore *::operator=;
%ignore *::operator<<;

namespace Roan_trail
{
  namespace Tovero_support
  {
    //   Error
    %rename("base_error=") Error::set_base_error(const Error* base_error);
    //   Error param
    %rename("error") Error_param::operator();
    %predicate Error_param::need_error() const;
    %predicate Error_param::is_valid_at_return() const;
    %rename("has_error?") Error_param::operator bool() const;
    %rename("base") Error_param::operator()() const;
    %rename("name=") Reference_counting_base::set_name(const std::string& name);
  }
}

#endif // SWIGRUBY

// add support for the STL

%include <stl.i>
%include <std_list.i>
%include <std_vector.i>
%import <std_iostream.i>

%warnfilter(503) operator <<;

//
// Wrap classes
//

%include "Logger.hpp"
%include "Reference_counting_base.hpp"
%include "Reference_counting_list.hpp"
%include "Reference_counting_map.hpp"
//
%include "error/Error.hpp"
extend_str(Roan_trail::Tovero_support::Error);
%include "error/Graphics_error.hpp"
%include "error/Math_error.hpp"

//
// Setup for reference counting
//

%feature("ref") Roan_trail::Tovero_support::Reference_counting_base "$this->reference();"
%feature("unref") Roan_trail::Tovero_support::Reference_counting_base "$this->unreference();"
