/* tpb - program to use the IBM ThinkPad(tm) special keys
 * Copyright (C) 2002 Markus Braun <markus.braun@krawel.de>
 *
 * This file is part of tpb.
 *
 * tpb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * tpb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tpb; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __CFG_H__
#define __CFG_H__

enum mode {MODE_COMMENT, MODE_INDENT, MODE_KEYWORD, MODE_SEPARATOR, MODE_ARGUMENT, MODE_END};

/* configuration defaults */
#define POLLTIME 1000
#define NVRAMDEV "/dev/nvram"
#ifdef HAVE_LIBXOSD
#define OSDFONT "-*-lucidatypewriter-medium-r-normal-*-*-250-*-*-*-*-*-*"
#define OSDCOLOR "BLUE"
#define OSDTIMEOUT 3
#define OSDOFFSET 25
#define OSDPOS XOSD_bottom
#endif /* HAVE_LIBXOSD */

/* Keywords in configuration file */
#define CFG_NVRAM "nvram"
#define CFG_POLLTIME "polltime"
#define CFG_THINKPAD "thinkpad"
#ifdef HAVE_LIBXOSD
#define CFG_OSDFONT "osdfont"
#define CFG_OSDCOLOR "osdcolor"
#define CFG_OSDTIMEOUT "osdtimeout"
#define CFG_OSDOFFSET "osdoffset"
#define CFG_OSDPOS "osdpos"
#define CFG_OSDPOS_TOP "top"
#define CFG_OSDPOS_BOTTOM "bottom"
#define CFG_OSD "osd"
#define CFG_OSD_ON "on"
#define CFG_OSD_OFF "off"
#endif /* HAVE_LIBXOSD */

#define BSIZE 256

typedef struct {
	char *nvram;
	int osd;
	int polltime;
	char *tpbcmd;
	int verbose;
#ifdef HAVE_LIBXOSD
	char *osdfont;
	char *osdcolor;
	int osdtimeout;
	int osdoffset;
	xosd_pos osdpos;
#endif /* HAVE_LIBXOSD */
} config;

int read_cfg_file(char *name);
void init_cfg(void);
void override_cfg(config *master);
void set_value(char *key, char *arg, config *cfg);
void parse_option(int argc, char **argv);
void print_usage(const char *prog);

#endif /* __CFG_H__ */

/* vim:set sw=2:set ts=2: */
/* vim600:set fen:set fdm=marker:set fdl=0: */
