dnl AM_PATH_LIBXOSD([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test to see if libxosd is installed, and define LIBXOSD_CFLAGS, LIBXOSDLIBS
dnl By Oron Peled (Sun Jun 30 2002) (taken from libxosd-dev debian package)
AC_DEFUN(AM_PATH_LIBXOSD,
[
	dnl
	dnl Get the cflags and libraries from the xosd-config script
	dnl
	AC_ARG_WITH(xosd-config,
		[  --with-xosd-config=LIBXOSD_CONFIG	Location of xosd-config],
		LIBXOSD_CONFIG="$withval"
	)

	AC_PATH_PROG(LIBXOSD_CONFIG, xosd-config, no)
	AC_MSG_CHECKING(for libxosd)
	if test "$LIBXOSD_CONFIG" = "no"; then
		AC_MSG_RESULT(no)
		ifelse([$2], , :, [$2])
	else
		LIBXOSD_CFLAGS=`$LIBXOSD_CONFIG --cflags 2>/dev/null`
		LIBXOSD_LIBS=`$LIBXOSD_CONFIG --libs 2>/dev/null`
		AC_MSG_RESULT(yes)
		ifelse([$1], , :, [$1])
	fi
	AC_SUBST(LIBXOSD_CFLAGS)
	AC_SUBST(LIBXOSD_LIBS)
])


dnl AM_CHECK_LIBXOSD
dnl Checks for LIBXOSD (>= 1.0.0)
AC_DEFUN(AM_CHECK_LIBXOSD,
[
		if test ! x$xosd_libdir = x; then
				LIBS="$LIBS -L$xosd_libdir"
		fi
		if test ! x$xosd_incdir = x; then
				CPPFLAGS="$CPPFLAGS -I$xosd_incdir"
		fi

		if test "x$enable_xosd" = "xyes"
		then
				dnl
				dnl Check its version
				dnl
				AC_MSG_CHECKING(for version of libxosd)
				CFLAGS="$CFLAGS $LIBXOSD_CFLAGS"
				LIBS="$LIBS $LIBXOSD_LIBS"
				dnl Check for version >= 0.7.0 and < 1.0.0
				AC_TRY_LINK(
					[
						#include <xosd.h>
					],
					[
						void test()
						{
							xosd* t = xosd_init("font", "colour", 0, XOSD_top, 0, 0);
						}
					],
					[
						AC_MSG_RESULT([>= 0.7.0, ok])
						AC_DEFINE(HAVE_LIBXOSD0)
					],
					[
						dnl Check for version >= 2.0.0
						dnl first 2.0.0, because 2.0.0 has the same xosd_init as 1.x.x
						AC_TRY_LINK(																												
							[																																	
								#include <xosd.h>																								
							],																																
							[																																	
								void test()																											
								{																																
									xosd* t = xosd_create(0);  
								}																																
							],																																
							[																																	
								AC_MSG_RESULT([>= 2.0.0, ok])																		
								AC_DEFINE(HAVE_LIBXOSD2)																				 
							],																																
							[																																	
								dnl Check for version >= 1.0.0 and < 2.0.0
								AC_TRY_LINK(																												
									[																																	
										#include <xosd.h>																								
									],																																
									[																																	
										void test()																											
										{																																
											xosd* t = xosd_init("font", "colour", 0, XOSD_top, 0, 0, 0);	
										}																																
									],																																
									[																																	
										AC_MSG_RESULT([>= 1.0.0, ok])																		
										AC_DEFINE(HAVE_LIBXOSD1)																				 
									],																																
									[																																	
										AC_MSG_RESULT([< 0.7.0, failed])																
										echo "*** The version of XOSD library installed is not 0.7.0 or"
										echo "*** above, make sure the correct version is installed."		
										exit 1																													
									]																																	
								 )																																	 
							]																																	
						 )																																	 
					]
				)
		fi
])
