/*
 * tokenise.h: break a string into a list of tokens
 *
 * Copyright (c) 2000 Chris Lightfoot. All rights reserved.
 *
 * $Id: tokenise.h,v 1.5 2002/10/22 00:06:27 chris Exp $
 *
 */

#ifndef __TOKENISE_H_ /* include guard */
#define __TOKENISE_H_

/* tokens:
 * Structure associated with tokenising a string. */
typedef struct _tokens {
    char *str;
    char **toks;
    int num;
} *tokens;

/* tokenise.c */
void chomp(char *str);
tokens tokens_new(const char *str, const char *seps);
void tokens_delete(tokens T);

#endif /* __TOKENISE_H_ */
