#!/bin/bash

# Copyright (C) 2016, 2018  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T gen-compact-c-code-path-function-unique-prefix-alphabets-array
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-compact-c-code-path-function-unique-prefix-alphabets-array.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ ../src/trie --attrs --dots --gen=compact --output=c-code --path=function --unique-prefix --trie=array < alphabets.txt
.   // [25,'\''z'\'']
.   switch (*p ++) {
.   // [0,"",'\''a'\'',[8,'\''z'\'']]
.   case '\''a'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "aa";
.   .   .   return error;
.   .   // [0,"",'\''f'\'',[0]]
.   .   case '\''f'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "af";
.   .   .   return error;
.   .   // [0,"g",'\''q'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''q'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "agq";
.   .   .   return error;
.   .   // [0,"",'\''k'\'',[0]]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ak";
.   .   .   return error;
.   .   // [0,"",'\''m'\'',[0]]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "am";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[0]]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ar";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[2,'\''t'\'']]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "as";
.   .   .   switch (*p ++) {
.   .   .   // [0,"",'\''a'\'',[0]]
.   .   .   case '\''a'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "asa";
.   .   .   .   return error;
.   .   .   // [0,"",'\''t'\'',[0]]
.   .   .   case '\''t'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ast";
.   .   .   }
.   .   .   return error;
.   .   // [0,"",'\''z'\'',[1,'\''_'\'']]
.   .   case '\''z'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "az";
.   .   .   // [0,"_Cyr",'\''l'\'',[0]]
.   .   .   if (prefix(p, "_Cyrl"))
.   .   .   .   return "az_Cyrl";
.   .   }
.   .   return error;
.   // [0,"",'\''b'\'',[9,'\''y'\'']]
.   case '\''b'\'':
.   .   switch (*p ++) {
.   .   // [0,"a",'\''s'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''s'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "bas";
.   .   .   return error;
.   .   // [0,"",'\''e'\'',[2,'\''z'\'']]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "be";
.   .   .   switch (*p ++) {
.   .   .   // [0,"",'\''m'\'',[0]]
.   .   .   case '\''m'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "bem";
.   .   .   .   return error;
.   .   .   // [0,"",'\''z'\'',[0]]
.   .   .   case '\''z'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "bez";
.   .   .   }
.   .   .   return error;
.   .   // [0,"",'\''g'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bg";
.   .   .   return error;
.   .   // [0,"",'\''m'\'',[0]]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bm";
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[0]]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bn";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[0]]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bo";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[1,'\''x'\'']]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "br";
.   .   .   // [0,"",'\''x'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''x'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "brx";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[1,'\''_'\'']]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "bs";
.   .   .   // [0,"_Cyr",'\''l'\'',[0]]
.   .   .   if (prefix(p, "_Cyrl"))
.   .   .   .   return "bs_Cyrl";
.   .   .   return error;
.   .   // [0,"y",'\''n'\'',[0]]
.   .   case '\''y'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''n'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "byn";
.   .   }
.   .   return error;
.   // [0,"",'\''c'\'',[5,'\''y'\'']]
.   case '\''c'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ca";
.   .   .   return error;
.   .   // [0,"g",'\''g'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''g'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "cgg";
.   .   .   return error;
.   .   // [0,"h",'\''r'\'',[0]]
.   .   case '\''h'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''r'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "chr";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "cs";
.   .   .   return error;
.   .   // [0,"",'\''y'\'',[0]]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "cy";
.   .   }
.   .   return error;
.   // [0,"",'\''d'\'',[6,'\''z'\'']]
.   case '\''d'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[1,'\''v'\'']]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "da";
.   .   .   // [0,"",'\''v'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''v'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "dav";
.   .   .   return error;
.   .   // [0,"",'\''e'\'',[0]]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "de";
.   .   .   return error;
.   .   // [0,"j",'\''e'\'',[0]]
.   .   case '\''j'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''e'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "dje";
.   .   .   return error;
.   .   // [0,"u",'\''a'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''a'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "dua";
.   .   .   return error;
.   .   // [0,"y",'\''o'\'',[0]]
.   .   case '\''y'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''o'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "dyo";
.   .   .   return error;
.   .   // [0,"",'\''z'\'',[0]]
.   .   case '\''z'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "dz";
.   .   }
.   .   return error;
.   // [0,"",'\''e'\'',[9,'\''w'\'']]
.   case '\''e'\'':
.   .   switch (*p ++) {
.   .   // [0,"b",'\''u'\'',[0]]
.   .   case '\''b'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''u'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "ebu";
.   .   .   return error;
.   .   // [0,"",'\''e'\'',[0]]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ee";
.   .   .   return error;
.   .   // [0,"",'\''l'\'',[0]]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "el";
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[0]]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "en";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[0]]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "eo";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "es";
.   .   .   return error;
.   .   // [0,"",'\''t'\'',[0]]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "et";
.   .   .   return error;
.   .   // [0,"",'\''u'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "eu";
.   .   .   return error;
.   .   // [0,"w",'\''o'\'',[0]]
.   .   case '\''w'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''o'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "ewo";
.   .   }
.   .   return error;
.   // [0,"",'\''f'\'',[7,'\''y'\'']]
.   case '\''f'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fa";
.   .   .   return error;
.   .   // [0,"",'\''f'\'',[0]]
.   .   case '\''f'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ff";
.   .   .   return error;
.   .   // [0,"",'\''i'\'',[1,'\''l'\'']]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fi";
.   .   .   // [0,"",'\''l'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''l'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "fil";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[0]]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fo";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[0]]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fr";
.   .   .   return error;
.   .   // [0,"u",'\''r'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''r'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "fur";
.   .   .   return error;
.   .   // [0,"",'\''y'\'',[0]]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "fy";
.   .   }
.   .   return error;
.   // [0,"",'\''g'\'',[6,'\''v'\'']]
.   case '\''g'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ga";
.   .   .   return error;
.   .   // [0,"",'\''d'\'',[0]]
.   .   case '\''d'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "gd";
.   .   .   return error;
.   .   // [0,"",'\''l'\'',[0]]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "gl";
.   .   .   return error;
.   .   // [0,"s",'\''w'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''w'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "gsw";
.   .   .   return error;
.   .   // [0,"",'\''u'\'',[1,'\''z'\'']]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "gu";
.   .   .   // [0,"",'\''z'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''z'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "guz";
.   .   .   return error;
.   .   // [0,"",'\''v'\'',[0]]
.   .   case '\''v'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "gv";
.   .   }
.   .   return error;
.   // [0,"",'\''h'\'',[6,'\''y'\'']]
.   case '\''h'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[1,'\''w'\'']]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ha";
.   .   .   // [0,"",'\''w'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''w'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "haw";
.   .   .   return error;
.   .   // [0,"",'\''e'\'',[0]]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "he";
.   .   .   return error;
.   .   // [0,"",'\''i'\'',[0]]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "hi";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[0]]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "hr";
.   .   .   return error;
.   .   // [0,"",'\''u'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "hu";
.   .   .   return error;
.   .   // [0,"",'\''y'\'',[0]]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "hy";
.   .   }
.   .   return error;
.   // [0,"",'\''i'\'',[6,'\''t'\'']]
.   case '\''i'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ia";
.   .   .   return error;
.   .   // [0,"",'\''d'\'',[0]]
.   .   case '\''d'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "id";
.   .   .   return error;
.   .   // [0,"",'\''g'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ig";
.   .   .   return error;
.   .   // [0,"",'\''i'\'',[0]]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ii";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "is";
.   .   .   return error;
.   .   // [0,"",'\''t'\'',[0]]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "it";
.   .   }
.   .   return error;
.   // [0,"",'\''j'\'',[3,'\''m'\'']]
.   case '\''j'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ja";
.   .   .   return error;
.   .   // [0,"g",'\''o'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''o'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "jgo";
.   .   .   return error;
.   .   // [0,"m",'\''c'\'',[0]]
.   .   case '\''m'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''c'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "jmc";
.   .   }
.   .   return error;
.   // [0,"",'\''k'\'',[13,'\''y'\'']]
.   case '\''k'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[2,'\''m'\'']]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ka";
.   .   .   switch (*p ++) {
.   .   .   // [0,"",'\''b'\'',[0]]
.   .   .   case '\''b'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kab";
.   .   .   .   return error;
.   .   .   // [0,"",'\''m'\'',[0]]
.   .   .   case '\''m'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "kam";
.   .   .   }
.   .   .   return error;
.   .   // [0,"d",'\''e'\'',[0]]
.   .   case '\''d'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''e'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "kde";
.   .   .   return error;
.   .   // [0,"e",'\''a'\'',[0]]
.   .   case '\''e'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''a'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "kea";
.   .   .   return error;
.   .   // [0,"h",'\''q'\'',[0]]
.   .   case '\''h'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''q'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "khq";
.   .   .   return error;
.   .   // [0,"",'\''i'\'',[0]]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ki";
.   .   .   return error;
.   .   // [0,"",'\''k'\'',[1,'\''j'\'']]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "kk";
.   .   .   // [0,"",'\''j'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''j'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "kkj";
.   .   .   return error;
.   .   // [0,"",'\''l'\'',[1,'\''n'\'']]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "kl";
.   .   .   // [0,"",'\''n'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''n'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "kln";
.   .   .   return error;
.   .   // [0,"",'\''m'\'',[0]]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "km";
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[0]]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "kn";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[1,'\''k'\'']]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ko";
.   .   .   // [0,"",'\''k'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''k'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "kok";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[3,'\''h'\'']]
.   .   case '\''s'\'':
.   .   .   switch (*p ++) {
.   .   .   // [0,"",'\''b'\'',[0]]
.   .   .   case '\''b'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ksb";
.   .   .   .   return error;
.   .   .   // [0,"",'\''f'\'',[0]]
.   .   .   case '\''f'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ksf";
.   .   .   .   return error;
.   .   .   // [0,"",'\''h'\'',[0]]
.   .   .   case '\''h'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ksh";
.   .   .   }
.   .   .   return error;
.   .   // [0,"",'\''w'\'',[0]]
.   .   case '\''w'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "kw";
.   .   .   return error;
.   .   // [0,"",'\''y'\'',[0]]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ky";
.   .   }
.   .   return error;
.   // [0,"",'\''l'\'',[8,'\''v'\'']]
.   case '\''l'\'':
.   .   switch (*p ++) {
.   .   // [0,"a",'\''g'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''g'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "lag";
.   .   .   return error;
.   .   // [0,"",'\''g'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lg";
.   .   .   return error;
.   .   // [0,"k",'\''t'\'',[0]]
.   .   case '\''k'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''t'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "lkt";
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[0]]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ln";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[0]]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lo";
.   .   .   return error;
.   .   // [0,"",'\''t'\'',[0]]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lt";
.   .   .   return error;
.   .   // [0,"",'\''u'\'',[2,'\''y'\'']]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lu";
.   .   .   switch (*p ++) {
.   .   .   // [0,"",'\''o'\'',[0]]
.   .   .   case '\''o'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "luo";
.   .   .   .   return error;
.   .   .   // [0,"",'\''y'\'',[0]]
.   .   .   case '\''y'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "luy";
.   .   .   }
.   .   .   return error;
.   .   // [0,"",'\''v'\'',[0]]
.   .   case '\''v'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "lv";
.   .   }
.   .   return error;
.   // [0,"",'\''m'\'',[12,'\''y'\'']]
.   case '\''m'\'':
.   .   switch (*p ++) {
.   .   // [0,"a",'\''s'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''s'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "mas";
.   .   .   return error;
.   .   // [0,"e",'\''r'\'',[0]]
.   .   case '\''e'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''r'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "mer";
.   .   .   return error;
.   .   // [0,"f",'\''e'\'',[0]]
.   .   case '\''f'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''e'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "mfe";
.   .   .   return error;
.   .   // [0,"",'\''g'\'',[2,'\''o'\'']]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mg";
.   .   .   switch (*p ++) {
.   .   .   // [0,"",'\''h'\'',[0]]
.   .   .   case '\''h'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "mgh";
.   .   .   .   return error;
.   .   .   // [0,"",'\''o'\'',[0]]
.   .   .   case '\''o'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "mgo";
.   .   .   }
.   .   .   return error;
.   .   // [0,"",'\''k'\'',[0]]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mk";
.   .   .   return error;
.   .   // [0,"",'\''l'\'',[0]]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ml";
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[0]]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mn";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[0]]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mr";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ms";
.   .   .   return error;
.   .   // [0,"",'\''t'\'',[0]]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "mt";
.   .   .   return error;
.   .   // [0,"u",'\''a'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''a'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "mua";
.   .   .   return error;
.   .   // [0,"",'\''y'\'',[0]]
.   .   case '\''y'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "my";
.   .   }
.   .   return error;
.   // [0,"",'\''n'\'',[11,'\''y'\'']]
.   case '\''n'\'':
.   .   switch (*p ++) {
.   .   // [0,"a",'\''q'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''q'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "naq";
.   .   .   return error;
.   .   // [0,"",'\''b'\'',[0]]
.   .   case '\''b'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nb";
.   .   .   return error;
.   .   // [0,"",'\''d'\'',[0]]
.   .   case '\''d'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nd";
.   .   .   return error;
.   .   // [0,"",'\''e'\'',[0]]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ne";
.   .   .   return error;
.   .   // [0,"",'\''l'\'',[0]]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nl";
.   .   .   return error;
.   .   // [0,"m",'\''g'\'',[0]]
.   .   case '\''m'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''g'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "nmg";
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[1,'\''h'\'']]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nn";
.   .   .   // [0,"",'\''h'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''h'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "nnh";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[0]]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "nr";
.   .   .   return error;
.   .   // [0,"s",'\''o'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''o'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "nso";
.   .   .   return error;
.   .   // [0,"u",'\''s'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''s'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "nus";
.   .   .   return error;
.   .   // [0,"y",'\''n'\'',[0]]
.   .   case '\''y'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''n'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "nyn";
.   .   }
.   .   return error;
.   // [0,"",'\''o'\'',[3,'\''s'\'']]
.   case '\''o'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''m'\'',[0]]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "om";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[0]]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "or";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "os";
.   .   }
.   .   return error;
.   // [0,"",'\''p'\'',[4,'\''t'\'']]
.   case '\''p'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[1,'\''_'\'']]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "pa";
.   .   .   // [0,"_Ara",'\''b'\'',[0]]
.   .   .   if (prefix(p, "_Arab"))
.   .   .   .   return "pa_Arab";
.   .   .   return error;
.   .   // [0,"",'\''l'\'',[0]]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "pl";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ps";
.   .   .   return error;
.   .   // [0,"",'\''t'\'',[0]]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "pt";
.   .   }
.   .   return error;
.   // [0,"",'\''r'\'',[5,'\''w'\'']]
.   case '\''r'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''m'\'',[0]]
.   .   case '\''m'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "rm";
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[0]]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "rn";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[1,'\''f'\'']]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ro";
.   .   .   // [0,"",'\''f'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''f'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "rof";
.   .   .   return error;
.   .   // [0,"",'\''u'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ru";
.   .   .   return error;
.   .   // [0,"",'\''w'\'',[1,'\''k'\'']]
.   .   case '\''w'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "rw";
.   .   .   // [0,"",'\''k'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''k'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "rwk";
.   .   }
.   .   return error;
.   // [0,"",'\''s'\'',[16,'\''w'\'']]
.   case '\''s'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[2,'\''q'\'']]
.   .   case '\''a'\'':
.   .   .   switch (*p ++) {
.   .   .   // [0,"",'\''h'\'',[0]]
.   .   .   case '\''h'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "sah";
.   .   .   .   return error;
.   .   .   // [0,"",'\''q'\'',[0]]
.   .   .   case '\''q'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "saq";
.   .   .   }
.   .   .   return error;
.   .   // [0,"b",'\''p'\'',[0]]
.   .   case '\''b'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''p'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "sbp";
.   .   .   return error;
.   .   // [0,"",'\''e'\'',[2,'\''s'\'']]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "se";
.   .   .   switch (*p ++) {
.   .   .   // [0,"",'\''h'\'',[0]]
.   .   .   case '\''h'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "seh";
.   .   .   .   return error;
.   .   .   // [0,"",'\''s'\'',[0]]
.   .   .   case '\''s'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "ses";
.   .   .   }
.   .   .   return error;
.   .   // [0,"",'\''g'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sg";
.   .   .   return error;
.   .   // [0,"h",'\''i'\'',[1,'\''_'\'']]
.   .   case '\''h'\'':
.   .   .   if (*p ++ == '\''i'\'') {
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "shi";
.   .   .   .   // [1,"h_Lat",'\''n'\'',[0]]
.   .   .   .   if (prefix(p, "_Latn"))
.   .   .   .   .   return "shi_Latn";
.   .   .   }
.   .   .   return error;
.   .   // [0,"",'\''i'\'',[0]]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "si";
.   .   .   return error;
.   .   // [0,"",'\''k'\'',[0]]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sk";
.   .   .   return error;
.   .   // [0,"",'\''l'\'',[0]]
.   .   case '\''l'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sl";
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[0]]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sn";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[0]]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "so";
.   .   .   return error;
.   .   // [0,"",'\''q'\'',[0]]
.   .   case '\''q'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sq";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[1,'\''_'\'']]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sr";
.   .   .   // [0,"_Lat",'\''n'\'',[0]]
.   .   .   if (prefix(p, "_Latn"))
.   .   .   .   return "sr_Latn";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[1,'\''y'\'']]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ss";
.   .   .   // [0,"",'\''y'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''y'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "ssy";
.   .   .   return error;
.   .   // [0,"",'\''t'\'',[0]]
.   .   case '\''t'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "st";
.   .   .   return error;
.   .   // [0,"",'\''v'\'',[0]]
.   .   case '\''v'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sv";
.   .   .   return error;
.   .   // [0,"",'\''w'\'',[1,'\''c'\'']]
.   .   case '\''w'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "sw";
.   .   .   // [0,"",'\''c'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''c'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "swc";
.   .   }
.   .   return error;
.   // [0,"",'\''t'\'',[11,'\''z'\'']]
.   case '\''t'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''a'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ta";
.   .   .   return error;
.   .   // [0,"",'\''e'\'',[1,'\''o'\'']]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "te";
.   .   .   // [0,"",'\''o'\'',[0]]
.   .   .   if ((*p == 0 || (*p ++ == '\''o'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "teo";
.   .   .   return error;
.   .   // [0,"",'\''g'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "tg";
.   .   .   return error;
.   .   // [0,"",'\''h'\'',[0]]
.   .   case '\''h'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "th";
.   .   .   return error;
.   .   // [0,"",'\''i'\'',[2,'\''g'\'']]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ti";
.   .   .   switch (*p ++) {
.   .   .   // [0,"_E",'\''R'\'',[0]]
.   .   .   case '\''_'\'':
.   .   .   .   if (prefix(p, "ER"))
.   .   .   .   .   return "ti_ER";
.   .   .   .   return error;
.   .   .   // [0,"",'\''g'\'',[0]]
.   .   .   case '\''g'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "tig";
.   .   .   }
.   .   .   return error;
.   .   // [0,"",'\''n'\'',[0]]
.   .   case '\''n'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "tn";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[0]]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "to";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[0]]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "tr";
.   .   .   return error;
.   .   // [0,"",'\''s'\'',[0]]
.   .   case '\''s'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ts";
.   .   .   return error;
.   .   // [0,"w",'\''q'\'',[0]]
.   .   case '\''w'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''q'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "twq";
.   .   .   return error;
.   .   // [0,"z",'\''m'\'',[0]]
.   .   case '\''z'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''m'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "tzm";
.   .   }
.   .   return error;
.   // [0,"",'\''u'\'',[4,'\''z'\'']]
.   case '\''u'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''g'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ug";
.   .   .   return error;
.   .   // [0,"",'\''k'\'',[0]]
.   .   case '\''k'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "uk";
.   .   .   return error;
.   .   // [0,"",'\''r'\'',[0]]
.   .   case '\''r'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ur";
.   .   .   return error;
.   .   // [0,"",'\''z'\'',[1,'\''_'\'']]
.   .   case '\''z'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "uz";
.   .   .   // [0,"",'\''_'\'',[2,'\''C'\'']]
.   .   .   if (*p ++ == '\''_'\'') {
.   .   .   .   switch (*p ++) {
.   .   .   .   // [0,"Ara",'\''b'\'',[0]]
.   .   .   .   case '\''A'\'':
.   .   .   .   .   if (prefix(p, "rab"))
.   .   .   .   .   .   return "uz_Arab";
.   .   .   .   .   return error;
.   .   .   .   // [0,"Cyr",'\''l'\'',[0]]
.   .   .   .   case '\''C'\'':
.   .   .   .   .   if (prefix(p, "yrl"))
.   .   .   .   .   .   return "uz_Cyrl";
.   .   .   .   }
.   .   .   }
.   .   }
.   .   return error;
.   // [0,"",'\''v'\'',[5,'\''u'\'']]
.   case '\''v'\'':
.   .   switch (*p ++) {
.   .   // [0,"ai_Lat",'\''n'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if (prefix(p, "i_Latn"))
.   .   .   .   return "vai_Latn";
.   .   .   return error;
.   .   // [0,"",'\''e'\'',[0]]
.   .   case '\''e'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "ve";
.   .   .   return error;
.   .   // [0,"",'\''i'\'',[0]]
.   .   case '\''i'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "vi";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[0]]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "vo";
.   .   .   return error;
.   .   // [0,"u",'\''n'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''n'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "vun";
.   .   }
.   .   return error;
.   // [0,"w",'\''a'\'',[2,'\''l'\'']]
.   case '\''w'\'':
.   .   if (*p ++ == '\''a'\'') {
.   .   .   switch (*p ++) {
.   .   .   // [1,"w",'\''e'\'',[0]]
.   .   .   case '\''e'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "wae";
.   .   .   .   return error;
.   .   .   // [1,"w",'\''l'\'',[0]]
.   .   .   case '\''l'\'':
.   .   .   .   if (*p == 0)
.   .   .   .   .   return "wal";
.   .   .   }
.   .   }
.   .   return error;
.   // [0,"",'\''x'\'',[2,'\''o'\'']]
.   case '\''x'\'':
.   .   switch (*p ++) {
.   .   // [0,"",'\''h'\'',[0]]
.   .   case '\''h'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "xh";
.   .   .   return error;
.   .   // [0,"o",'\''g'\'',[0]]
.   .   case '\''o'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''g'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "xog";
.   .   }
.   .   return error;
.   // [0,"",'\''y'\'',[2,'\''o'\'']]
.   case '\''y'\'':
.   .   switch (*p ++) {
.   .   // [0,"a",'\''v'\'',[0]]
.   .   case '\''a'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''v'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "yav";
.   .   .   return error;
.   .   // [0,"",'\''o'\'',[1,'\''_'\'']]
.   .   case '\''o'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "yo";
.   .   .   // [0,"_B",'\''J'\'',[0]]
.   .   .   if (prefix(p, "_BJ"))
.   .   .   .   return "yo_BJ";
.   .   }
.   .   return error;
.   // [0,"",'\''z'\'',[3,'\''u'\'']]
.   case '\''z'\'':
.   .   switch (*p ++) {
.   .   // [0,"g",'\''h'\'',[0]]
.   .   case '\''g'\'':
.   .   .   if ((*p == 0 || (*p ++ == '\''h'\'' &&
.   .   .   .   (*p == 0))))
.   .   .   .   return "zgh";
.   .   .   return error;
.   .   // [0,"",'\''h'\'',[1,'\''_'\'']]
.   .   case '\''h'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "zh";
.   .   .   // [0,"_Han",'\''t'\'',[0]]
.   .   .   if (prefix(p, "_Hant"))
.   .   .   .   return "zh_Hant";
.   .   .   return error;
.   .   // [0,"",'\''u'\'',[0]]
.   .   case '\''u'\'':
.   .   .   if (*p == 0)
.   .   .   .   return "zu";
.   .   }
.   }
.   return error;'
) -L gen-compact-c-code-path-function-unique-prefix-alphabets-array.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ ../src/trie --attrs --dots --gen=compact --output=c-code --path=function --unique-prefix --trie=array < alphabets.txt'
../src/trie --attrs --dots --gen=compact --output=c-code --path=function --unique-prefix --trie=array < alphabets.txt 2>&1 ||
echo 'command failed: ../src/trie --attrs --dots --gen=compact --output=c-code --path=function --unique-prefix --trie=array < alphabets.txt'
)

