#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T gen-compact-trie-base-ternary
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-compact-trie-base-ternary.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ trie() { ../src/trie --gen=compact --output=trie --attrs --dots --trie=ternary "$@"; }
$ print|trie
trie: error: tries cannot contain empty keys
command failed: print|trie
$ print a|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[0]]: "a"
}
$ print a b|trie
[2,'\''b'\''] {
.   "a" [0,"",'\''a'\'',[0]]: "a"
.   "b" [0,"",'\''b'\'',[0]]: "b"
}
$ print a b c|trie
[3,'\''c'\''] {
.   "a" [0,"",'\''a'\'',[0]]: "a"
.   "b" [0,"",'\''b'\'',[0]]: "b"
.   "c" [0,"",'\''c'\'',[0]]: "c"
}
$ print a ab abc|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[1,'\''b'\'']]: "a" {
.   .   "b" [0,"",'\''b'\'',[1,'\''c'\'']]: "ab" {
.   .   .   "c" [0,"",'\''c'\'',[0]]: "abc"
.   .   }
.   }
}
$ print a ab ac|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[2,'\''c'\'']]: "a" {
.   .   "b" [0,"",'\''b'\'',[0]]: "ab"
.   .   "c" [0,"",'\''c'\'',[0]]: "ac"
.   }
}
$ print a ab ac ad|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[3,'\''d'\'']]: "a" {
.   .   "b" [0,"",'\''b'\'',[0]]: "ab"
.   .   "c" [0,"",'\''c'\'',[0]]: "ac"
.   .   "d" [0,"",'\''d'\'',[0]]: "ad"
.   }
}
$ print a abd ac|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[2,'\''c'\'']]: "a" {
.   .   "bd" [0,"b",'\''d'\'',[0]]: "abd"
.   .   "c" [0,"",'\''c'\'',[0]]: "ac"
.   }
}
$ print a ab ac acd|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[2,'\''c'\'']]: "a" {
.   .   "b" [0,"",'\''b'\'',[0]]: "ab"
.   .   "c" [0,"",'\''c'\'',[1,'\''d'\'']]: "ac" {
.   .   .   "d" [0,"",'\''d'\'',[0]]: "acd"
.   .   }
.   }
}
$ print a bb ba ccc|trie
[3,'\''c'\''] {
.   "a" [0,"",'\''a'\'',[0]]: "a"
.   "b" [0,"",'\''b'\'',[2,'\''b'\'']] {
.   .   "a" [0,"",'\''a'\'',[0]]: "ba"
.   .   "b" [0,"",'\''b'\'',[0]]: "bb"
.   }
.   "ccc" [0,"cc",'\''c'\'',[0]]: "ccc"
}
$ print a bb ccc|trie
[3,'\''c'\''] {
.   "a" [0,"",'\''a'\'',[0]]: "a"
.   "bb" [0,"b",'\''b'\'',[0]]: "bb"
.   "ccc" [0,"cc",'\''c'\'',[0]]: "ccc"
}
$ print a bb ba ccc|trie
[3,'\''c'\''] {
.   "a" [0,"",'\''a'\'',[0]]: "a"
.   "b" [0,"",'\''b'\'',[2,'\''b'\'']] {
.   .   "a" [0,"",'\''a'\'',[0]]: "ba"
.   .   "b" [0,"",'\''b'\'',[0]]: "bb"
.   }
.   "ccc" [0,"cc",'\''c'\'',[0]]: "ccc"
}
$ print abc abd acde|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[2,'\''c'\'']] {
.   .   "b" [0,"",'\''b'\'',[2,'\''d'\'']] {
.   .   .   "c" [0,"",'\''c'\'',[0]]: "abc"
.   .   .   "d" [0,"",'\''d'\'',[0]]: "abd"
.   .   }
.   .   "cde" [0,"cd",'\''e'\'',[0]]: "acde"
.   }
}
$ print abc abd acde ac|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[2,'\''c'\'']] {
.   .   "b" [0,"",'\''b'\'',[2,'\''d'\'']] {
.   .   .   "c" [0,"",'\''c'\'',[0]]: "abc"
.   .   .   "d" [0,"",'\''d'\'',[0]]: "abd"
.   .   }
.   .   "c" [0,"",'\''c'\'',[1,'\''d'\'']]: "ac" {
.   .   .   "de" [0,"d",'\''e'\'',[0]]: "acde"
.   .   }
.   }
}
$ print abc abd acde acfg|trie
[1,'\''a'\''] {
.   "a" [0,"",'\''a'\'',[2,'\''c'\'']] {
.   .   "b" [0,"",'\''b'\'',[2,'\''d'\'']] {
.   .   .   "c" [0,"",'\''c'\'',[0]]: "abc"
.   .   .   "d" [0,"",'\''d'\'',[0]]: "abd"
.   .   }
.   .   "c" [0,"",'\''c'\'',[2,'\''f'\'']] {
.   .   .   "de" [0,"d",'\''e'\'',[0]]: "acde"
.   .   .   "fg" [0,"f",'\''g'\'',[0]]: "acfg"
.   .   }
.   }
}
$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie
[1,'\''c'\''] {
.   "c" [0,"",'\''c'\'',[2,'\''f'\'']] {
.   .   "de" [0,"d",'\''e'\'',[0]]: "cde"
.   .   "fg" [0,"f",'\''g'\'',[1,'\''x'\'']]: "cfg" {
.   .   .   "x" [1,"f",'\''x'\'',[2,'\''z'\'']]: "cfgx" {
.   .   .   .   "y" [1,"f",'\''y'\'',[1,'\''z'\'']]: "cfgxy" {
.   .   .   .   .   "z" [1,"f",'\''z'\'',[0]]: "cfgxyz"
.   .   .   .   }
.   .   .   .   "zzz" [1,"fzz",'\''z'\'',[0]]: "cfgxzzz"
.   .   .   }
.   .   }
.   }
}
$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie
[1,'\''c'\''] {
.   "c" [0,"",'\''c'\'',[2,'\''g'\'']] {
.   .   "fg" [0,"f",'\''g'\'',[1,'\''x'\'']]: "cfg" {
.   .   .   "x" [1,"f",'\''x'\'',[2,'\''z'\'']]: "cfgx" {
.   .   .   .   "y" [1,"f",'\''y'\'',[1,'\''z'\'']]: "cfgxy" {
.   .   .   .   .   "z" [1,"f",'\''z'\'',[0]]: "cfgxyz"
.   .   .   .   }
.   .   .   .   "zzz" [1,"fzz",'\''z'\'',[0]]: "cfgxzzz"
.   .   .   }
.   .   }
.   .   "ge" [0,"g",'\''e'\'',[0]]: "cge"
.   }
}
$ print a abcd abcdefg h hijk|trie
[2,'\''h'\''] {
.   "a" [0,"",'\''a'\'',[1,'\''b'\'']]: "a" {
.   .   "bcd" [0,"bc",'\''d'\'',[1,'\''e'\'']]: "abcd" {
.   .   .   "efg" [2,"bcef",'\''g'\'',[0]]: "abcdefg"
.   .   }
.   }
.   "h" [0,"",'\''h'\'',[1,'\''i'\'']]: "h" {
.   .   "ijk" [0,"ij",'\''k'\'',[0]]: "hijk"
.   }
}
$ print a abcd abcdefg abcdxyz h hijk|trie
[2,'\''h'\''] {
.   "a" [0,"",'\''a'\'',[1,'\''b'\'']]: "a" {
.   .   "bcd" [0,"bc",'\''d'\'',[2,'\''x'\'']]: "abcd" {
.   .   .   "efg" [2,"bcef",'\''g'\'',[0]]: "abcdefg"
.   .   .   "xyz" [2,"bcxy",'\''z'\'',[0]]: "abcdxyz"
.   .   }
.   }
.   "h" [0,"",'\''h'\'',[1,'\''i'\'']]: "h" {
.   .   "ijk" [0,"ij",'\''k'\'',[0]]: "hijk"
.   }
}
$ print a abcd abcdefg abcdxyz h hijk hlm|trie
[2,'\''h'\''] {
.   "a" [0,"",'\''a'\'',[1,'\''b'\'']]: "a" {
.   .   "bcd" [0,"bc",'\''d'\'',[2,'\''x'\'']]: "abcd" {
.   .   .   "efg" [2,"bcef",'\''g'\'',[0]]: "abcdefg"
.   .   .   "xyz" [2,"bcxy",'\''z'\'',[0]]: "abcdxyz"
.   .   }
.   }
.   "h" [0,"",'\''h'\'',[2,'\''l'\'']]: "h" {
.   .   "ijk" [0,"ij",'\''k'\'',[0]]: "hijk"
.   .   "lm" [0,"l",'\''m'\'',[0]]: "hlm"
.   }
}'
) -L gen-compact-trie-base-ternary.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ trie() { ../src/trie --gen=compact --output=trie --attrs --dots --trie=ternary "$@"; }'
trie() { ../src/trie --gen=compact --output=trie --attrs --dots --trie=ternary "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --gen=compact --output=trie --attrs --dots --trie=ternary "$@"; }'

echo '$ print|trie'
print|trie 2>&1 ||
echo 'command failed: print|trie'

echo '$ print a|trie'
print a|trie 2>&1 ||
echo 'command failed: print a|trie'

echo '$ print a b|trie'
print a b|trie 2>&1 ||
echo 'command failed: print a b|trie'

echo '$ print a b c|trie'
print a b c|trie 2>&1 ||
echo 'command failed: print a b c|trie'

echo '$ print a ab abc|trie'
print a ab abc|trie 2>&1 ||
echo 'command failed: print a ab abc|trie'

echo '$ print a ab ac|trie'
print a ab ac|trie 2>&1 ||
echo 'command failed: print a ab ac|trie'

echo '$ print a ab ac ad|trie'
print a ab ac ad|trie 2>&1 ||
echo 'command failed: print a ab ac ad|trie'

echo '$ print a abd ac|trie'
print a abd ac|trie 2>&1 ||
echo 'command failed: print a abd ac|trie'

echo '$ print a ab ac acd|trie'
print a ab ac acd|trie 2>&1 ||
echo 'command failed: print a ab ac acd|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print a bb ccc|trie'
print a bb ccc|trie 2>&1 ||
echo 'command failed: print a bb ccc|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print abc abd acde|trie'
print abc abd acde|trie 2>&1 ||
echo 'command failed: print abc abd acde|trie'

echo '$ print abc abd acde ac|trie'
print abc abd acde ac|trie 2>&1 ||
echo 'command failed: print abc abd acde ac|trie'

echo '$ print abc abd acde acfg|trie'
print abc abd acde acfg|trie 2>&1 ||
echo 'command failed: print abc abd acde acfg|trie'

echo '$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie'
print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie 2>&1 ||
echo 'command failed: print cde cfg cfgx cfgxy cfgxyz cfgxzzz|trie'

echo '$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie'
print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie 2>&1 ||
echo 'command failed: print cge cfg cfgx cfgxy cfgxyz cfgxzzz|trie'

echo '$ print a abcd abcdefg h hijk|trie'
print a abcd abcdefg h hijk|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg h hijk|trie'

echo '$ print a abcd abcdefg abcdxyz h hijk|trie'
print a abcd abcdefg abcdxyz h hijk|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk|trie'

echo '$ print a abcd abcdefg abcdxyz h hijk hlm|trie'
print a abcd abcdefg abcdxyz h hijk hlm|trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk hlm|trie'
)

