#!/bin/bash

# Copyright (C) 2016, 2018, 2021  Stefan Vargyas
# 
# This file is part of Trie-Gen.
# 
# Trie-Gen is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Trie-Gen is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Trie-Gen.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ gen-test -T print-obj-base0-ternary
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L print-obj-base0-ternary.old <(echo \
'$ print() { printf '\''%s\n'\'' "$@"; }
$ trie() { ../src/trie --node=str --trie=ternary "$@"; }
$ print a|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
}
$ print a ab|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
        .hi {
            .ch: '\''b'\''
            .eq {
                .val: "ab"
            }
        }
    }
}
$ print a ab abc|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
        .hi {
            .ch: '\''b'\''
            .eq {
                .val: "ab"
                .hi {
                    .ch: '\''c'\''
                    .eq {
                        .val: "abc"
                    }
                }
            }
        }
    }
}
$ print a b|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .val: "b"
        }
    }
}
$ print a b abc bac abd|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
        .hi {
            .ch: '\''b'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .val: "abc"
                }
                .hi {
                    .ch: '\''d'\''
                    .eq {
                        .val: "abd"
                    }
                }
            }
        }
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .val: "b"
            .hi {
                .ch: '\''a'\''
                .eq {
                    .ch: '\''c'\''
                    .eq {
                        .val: "bac"
                    }
                }
            }
        }
    }
}
$ print a bb ba c|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .val: "c"
            }
        }
    }
}
$ print a bb ba cc|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .val: "cc"
                }
            }
        }
    }
}
$ print a bb ba ccc|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .ch: '\''c'\''
                    .eq {
                        .val: "ccc"
                    }
                }
            }
        }
    }
}
$ print a bb ba cde|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''d'\''
                .eq {
                    .ch: '\''e'\''
                    .eq {
                        .val: "cde"
                    }
                }
            }
        }
    }
}
$ print a bb ba cdef|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''d'\''
                .eq {
                    .ch: '\''e'\''
                    .eq {
                        .ch: '\''f'\''
                        .eq {
                            .val: "cdef"
                        }
                    }
                }
            }
        }
    }
}
$ print a bb ba cdef cdefg|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''d'\''
                .eq {
                    .ch: '\''e'\''
                    .eq {
                        .ch: '\''f'\''
                        .eq {
                            .val: "cdef"
                            .hi {
                                .ch: '\''g'\''
                                .eq {
                                    .val: "cdefg"
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
$ print a bb bac cdef|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .ch: '\''c'\''
                    .eq {
                        .val: "bac"
                    }
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''d'\''
                .eq {
                    .ch: '\''e'\''
                    .eq {
                        .ch: '\''f'\''
                        .eq {
                            .val: "cdef"
                        }
                    }
                }
            }
        }
    }
}
$ print a bbx ba ccc|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .ch: '\''x'\''
                .eq {
                    .val: "bbx"
                }
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .ch: '\''c'\''
                    .eq {
                        .val: "ccc"
                    }
                }
            }
        }
    }
}
$ print a bbx bay ccc|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .ch: '\''y'\''
                    .eq {
                        .val: "bay"
                    }
                }
            }
            .eq {
                .ch: '\''x'\''
                .eq {
                    .val: "bbx"
                }
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .ch: '\''c'\''
                    .eq {
                        .val: "ccc"
                    }
                }
            }
        }
    }
}
$ print a cde cdef|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''c'\''
        .eq {
            .ch: '\''d'\''
            .eq {
                .ch: '\''e'\''
                .eq {
                    .val: "cde"
                    .hi {
                        .ch: '\''f'\''
                        .eq {
                            .val: "cdef"
                        }
                    }
                }
            }
        }
    }
}
$ print a cde cdef cdefg|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''c'\''
        .eq {
            .ch: '\''d'\''
            .eq {
                .ch: '\''e'\''
                .eq {
                    .val: "cde"
                    .hi {
                        .ch: '\''f'\''
                        .eq {
                            .val: "cdef"
                            .hi {
                                .ch: '\''g'\''
                                .eq {
                                    .val: "cdefg"
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
$ print a cde cdef cdefgh|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''c'\''
        .eq {
            .ch: '\''d'\''
            .eq {
                .ch: '\''e'\''
                .eq {
                    .val: "cde"
                    .hi {
                        .ch: '\''f'\''
                        .eq {
                            .val: "cdef"
                            .hi {
                                .ch: '\''g'\''
                                .eq {
                                    .ch: '\''h'\''
                                    .eq {
                                        .val: "cdefgh"
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
$ print a cdef cdefg|trie
{
    .ch: '\''a'\''
    .eq {
        .val: "a"
    }
    .hi {
        .ch: '\''c'\''
        .eq {
            .ch: '\''d'\''
            .eq {
                .ch: '\''e'\''
                .eq {
                    .ch: '\''f'\''
                    .eq {
                        .val: "cdef"
                        .hi {
                            .ch: '\''g'\''
                            .eq {
                                .val: "cdefg"
                            }
                        }
                    }
                }
            }
        }
    }
}
$ print ab|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''b'\''
        .eq {
            .val: "ab"
        }
    }
}
$ print ab bb ba ccc|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''b'\''
        .eq {
            .val: "ab"
        }
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .ch: '\''c'\''
                    .eq {
                        .val: "ccc"
                    }
                }
            }
        }
    }
}
$ print ab bb ba cde|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''b'\''
        .eq {
            .val: "ab"
        }
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''d'\''
                .eq {
                    .ch: '\''e'\''
                    .eq {
                        .val: "cde"
                    }
                }
            }
        }
    }
}
$ print ab bbx ba ccc|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''b'\''
        .eq {
            .val: "ab"
        }
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .ch: '\''x'\''
                .eq {
                    .val: "bbx"
                }
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .ch: '\''c'\''
                    .eq {
                        .val: "ccc"
                    }
                }
            }
        }
    }
}
$ print ab c|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''b'\''
        .eq {
            .val: "ab"
        }
    }
    .hi {
        .ch: '\''c'\''
        .eq {
            .val: "c"
        }
    }
}
$ print abc bb ba ccc|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''b'\''
        .eq {
            .ch: '\''c'\''
            .eq {
                .val: "abc"
            }
        }
    }
    .hi {
        .ch: '\''b'\''
        .eq {
            .ch: '\''b'\''
            .lo {
                .ch: '\''a'\''
                .eq {
                    .val: "ba"
                }
            }
            .eq {
                .val: "bb"
            }
        }
        .hi {
            .ch: '\''c'\''
            .eq {
                .ch: '\''c'\''
                .eq {
                    .ch: '\''c'\''
                    .eq {
                        .val: "ccc"
                    }
                }
            }
        }
    }
}
$ print abcd abde abef|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''b'\''
        .eq {
            .ch: '\''c'\''
            .eq {
                .ch: '\''d'\''
                .eq {
                    .val: "abcd"
                }
            }
            .hi {
                .ch: '\''d'\''
                .eq {
                    .ch: '\''e'\''
                    .eq {
                        .val: "abde"
                    }
                }
                .hi {
                    .ch: '\''e'\''
                    .eq {
                        .ch: '\''f'\''
                        .eq {
                            .val: "abef"
                        }
                    }
                }
            }
        }
    }
}
$ print abg a abc ab abd|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''b'\''
        .lo {
            .val: "a"
        }
        .eq {
            .ch: '\''g'\''
            .lo {
                .ch: '\''c'\''
                .lo {
                    .val: "ab"
                }
                .eq {
                    .val: "abc"
                }
                .hi {
                    .ch: '\''d'\''
                    .eq {
                        .val: "abd"
                    }
                }
            }
            .eq {
                .val: "abg"
            }
        }
    }
}
$ print ac ab|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''c'\''
        .lo {
            .ch: '\''b'\''
            .eq {
                .val: "ab"
            }
        }
        .eq {
            .val: "ac"
        }
    }
}
$ print aef ae abg a abc ab abd|trie
{
    .ch: '\''a'\''
    .eq {
        .ch: '\''e'\''
        .lo {
            .ch: '\''b'\''
            .lo {
                .val: "a"
            }
            .eq {
                .ch: '\''g'\''
                .lo {
                    .ch: '\''c'\''
                    .lo {
                        .val: "ab"
                    }
                    .eq {
                        .val: "abc"
                    }
                    .hi {
                        .ch: '\''d'\''
                        .eq {
                            .val: "abd"
                        }
                    }
                }
                .eq {
                    .val: "abg"
                }
            }
        }
        .eq {
            .ch: '\''f'\''
            .lo {
                .val: "ae"
            }
            .eq {
                .val: "aef"
            }
        }
    }
}
$ print cde cdef cdefgh|trie
{
    .ch: '\''c'\''
    .eq {
        .ch: '\''d'\''
        .eq {
            .ch: '\''e'\''
            .eq {
                .val: "cde"
                .hi {
                    .ch: '\''f'\''
                    .eq {
                        .val: "cdef"
                        .hi {
                            .ch: '\''g'\''
                            .eq {
                                .ch: '\''h'\''
                                .eq {
                                    .val: "cdefgh"
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
$ print cdef cdefg|trie
{
    .ch: '\''c'\''
    .eq {
        .ch: '\''d'\''
        .eq {
            .ch: '\''e'\''
            .eq {
                .ch: '\''f'\''
                .eq {
                    .val: "cdef"
                    .hi {
                        .ch: '\''g'\''
                        .eq {
                            .val: "cdefg"
                        }
                    }
                }
            }
        }
    }
}
$ print cdex cdfy cdgz cdhw|trie
{
    .ch: '\''c'\''
    .eq {
        .ch: '\''d'\''
        .eq {
            .ch: '\''e'\''
            .eq {
                .ch: '\''x'\''
                .eq {
                    .val: "cdex"
                }
            }
            .hi {
                .ch: '\''f'\''
                .eq {
                    .ch: '\''y'\''
                    .eq {
                        .val: "cdfy"
                    }
                }
                .hi {
                    .ch: '\''g'\''
                    .eq {
                        .ch: '\''z'\''
                        .eq {
                            .val: "cdgz"
                        }
                    }
                    .hi {
                        .ch: '\''h'\''
                        .eq {
                            .ch: '\''w'\''
                            .eq {
                                .val: "cdhw"
                            }
                        }
                    }
                }
            }
        }
    }
}
$ print ce cdex cdfy cdgz cdhw|trie
{
    .ch: '\''c'\''
    .eq {
        .ch: '\''e'\''
        .lo {
            .ch: '\''d'\''
            .eq {
                .ch: '\''e'\''
                .eq {
                    .ch: '\''x'\''
                    .eq {
                        .val: "cdex"
                    }
                }
                .hi {
                    .ch: '\''f'\''
                    .eq {
                        .ch: '\''y'\''
                        .eq {
                            .val: "cdfy"
                        }
                    }
                    .hi {
                        .ch: '\''g'\''
                        .eq {
                            .ch: '\''z'\''
                            .eq {
                                .val: "cdgz"
                            }
                        }
                        .hi {
                            .ch: '\''h'\''
                            .eq {
                                .ch: '\''w'\''
                                .eq {
                                    .val: "cdhw"
                                }
                            }
                        }
                    }
                }
            }
        }
        .eq {
            .val: "ce"
        }
    }
}
$ print pot potato pottery tattoo tempo|trie
{
    .ch: '\''p'\''
    .eq {
        .ch: '\''o'\''
        .eq {
            .ch: '\''t'\''
            .eq {
                .val: "pot"
                .hi {
                    .ch: '\''a'\''
                    .eq {
                        .ch: '\''t'\''
                        .eq {
                            .ch: '\''o'\''
                            .eq {
                                .val: "potato"
                            }
                        }
                    }
                    .hi {
                        .ch: '\''t'\''
                        .eq {
                            .ch: '\''e'\''
                            .eq {
                                .ch: '\''r'\''
                                .eq {
                                    .ch: '\''y'\''
                                    .eq {
                                        .val: "pottery"
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    .hi {
        .ch: '\''t'\''
        .eq {
            .ch: '\''a'\''
            .eq {
                .ch: '\''t'\''
                .eq {
                    .ch: '\''t'\''
                    .eq {
                        .ch: '\''o'\''
                        .eq {
                            .ch: '\''o'\''
                            .eq {
                                .val: "tattoo"
                            }
                        }
                    }
                }
            }
            .hi {
                .ch: '\''e'\''
                .eq {
                    .ch: '\''m'\''
                    .eq {
                        .ch: '\''p'\''
                        .eq {
                            .ch: '\''o'\''
                            .eq {
                                .val: "tempo"
                            }
                        }
                    }
                }
            }
        }
    }
}'
) -L print-obj-base0-ternary.new <(
echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ trie() { ../src/trie --node=str --trie=ternary "$@"; }'
trie() { ../src/trie --node=str --trie=ternary "$@"; } 2>&1 ||
echo 'command failed: trie() { ../src/trie --node=str --trie=ternary "$@"; }'

echo '$ print a|trie'
print a|trie 2>&1 ||
echo 'command failed: print a|trie'

echo '$ print a ab|trie'
print a ab|trie 2>&1 ||
echo 'command failed: print a ab|trie'

echo '$ print a ab abc|trie'
print a ab abc|trie 2>&1 ||
echo 'command failed: print a ab abc|trie'

echo '$ print a b|trie'
print a b|trie 2>&1 ||
echo 'command failed: print a b|trie'

echo '$ print a b abc bac abd|trie'
print a b abc bac abd|trie 2>&1 ||
echo 'command failed: print a b abc bac abd|trie'

echo '$ print a bb ba c|trie'
print a bb ba c|trie 2>&1 ||
echo 'command failed: print a bb ba c|trie'

echo '$ print a bb ba cc|trie'
print a bb ba cc|trie 2>&1 ||
echo 'command failed: print a bb ba cc|trie'

echo '$ print a bb ba ccc|trie'
print a bb ba ccc|trie 2>&1 ||
echo 'command failed: print a bb ba ccc|trie'

echo '$ print a bb ba cde|trie'
print a bb ba cde|trie 2>&1 ||
echo 'command failed: print a bb ba cde|trie'

echo '$ print a bb ba cdef|trie'
print a bb ba cdef|trie 2>&1 ||
echo 'command failed: print a bb ba cdef|trie'

echo '$ print a bb ba cdef cdefg|trie'
print a bb ba cdef cdefg|trie 2>&1 ||
echo 'command failed: print a bb ba cdef cdefg|trie'

echo '$ print a bb bac cdef|trie'
print a bb bac cdef|trie 2>&1 ||
echo 'command failed: print a bb bac cdef|trie'

echo '$ print a bbx ba ccc|trie'
print a bbx ba ccc|trie 2>&1 ||
echo 'command failed: print a bbx ba ccc|trie'

echo '$ print a bbx bay ccc|trie'
print a bbx bay ccc|trie 2>&1 ||
echo 'command failed: print a bbx bay ccc|trie'

echo '$ print a cde cdef|trie'
print a cde cdef|trie 2>&1 ||
echo 'command failed: print a cde cdef|trie'

echo '$ print a cde cdef cdefg|trie'
print a cde cdef cdefg|trie 2>&1 ||
echo 'command failed: print a cde cdef cdefg|trie'

echo '$ print a cde cdef cdefgh|trie'
print a cde cdef cdefgh|trie 2>&1 ||
echo 'command failed: print a cde cdef cdefgh|trie'

echo '$ print a cdef cdefg|trie'
print a cdef cdefg|trie 2>&1 ||
echo 'command failed: print a cdef cdefg|trie'

echo '$ print ab|trie'
print ab|trie 2>&1 ||
echo 'command failed: print ab|trie'

echo '$ print ab bb ba ccc|trie'
print ab bb ba ccc|trie 2>&1 ||
echo 'command failed: print ab bb ba ccc|trie'

echo '$ print ab bb ba cde|trie'
print ab bb ba cde|trie 2>&1 ||
echo 'command failed: print ab bb ba cde|trie'

echo '$ print ab bbx ba ccc|trie'
print ab bbx ba ccc|trie 2>&1 ||
echo 'command failed: print ab bbx ba ccc|trie'

echo '$ print ab c|trie'
print ab c|trie 2>&1 ||
echo 'command failed: print ab c|trie'

echo '$ print abc bb ba ccc|trie'
print abc bb ba ccc|trie 2>&1 ||
echo 'command failed: print abc bb ba ccc|trie'

echo '$ print abcd abde abef|trie'
print abcd abde abef|trie 2>&1 ||
echo 'command failed: print abcd abde abef|trie'

echo '$ print abg a abc ab abd|trie'
print abg a abc ab abd|trie 2>&1 ||
echo 'command failed: print abg a abc ab abd|trie'

echo '$ print ac ab|trie'
print ac ab|trie 2>&1 ||
echo 'command failed: print ac ab|trie'

echo '$ print aef ae abg a abc ab abd|trie'
print aef ae abg a abc ab abd|trie 2>&1 ||
echo 'command failed: print aef ae abg a abc ab abd|trie'

echo '$ print cde cdef cdefgh|trie'
print cde cdef cdefgh|trie 2>&1 ||
echo 'command failed: print cde cdef cdefgh|trie'

echo '$ print cdef cdefg|trie'
print cdef cdefg|trie 2>&1 ||
echo 'command failed: print cdef cdefg|trie'

echo '$ print cdex cdfy cdgz cdhw|trie'
print cdex cdfy cdgz cdhw|trie 2>&1 ||
echo 'command failed: print cdex cdfy cdgz cdhw|trie'

echo '$ print ce cdex cdfy cdgz cdhw|trie'
print ce cdex cdfy cdgz cdhw|trie 2>&1 ||
echo 'command failed: print ce cdex cdfy cdgz cdhw|trie'

echo '$ print pot potato pottery tattoo tempo|trie'
print pot potato pottery tattoo tempo|trie 2>&1 ||
echo 'command failed: print pot potato pottery tattoo tempo|trie'
)

