--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

----------------------------------------------------------------------------
-- Ce paquetage contient toutes les affichage de texte.
-- Chaque element du programme devant afficher du texte a l'ecran doit y faire
-- appel.
--
-- Ce paquetage est destine a faciliter la traduction : il suffit de le
-- remplacer par le fichier de la langue desiree pour avoir le programme dans
-- sa langue (il pourra etre possible, dans les versions futures, de
-- configurer a l'execution la langue)
--
-- Remarque evidente : attention a la langue !
--  Le texte doit etre sans fautes d'orthographe ni de grammaire, dans un langage non familier. Pensez egalement a respecter la typographie.
---------------------------------------------------------------------------

package texte is

----------------------------meta--------------------------------------------
	-- Les fonctions suivantes affichent les informations demandees par
	-- l'utilisateur, qui ne sont pas des executions "classiques" du programme.

   procedure metaAide;
   -- Affiche de l'aide

   procedure metaVersion;
   -- Affiche la version

   procedure metaDiacritiques;
   -- Affiche la liste des diacritiques
	
--------------------------progression---------------------------------------
-- Affiche des informations sur l'avancement de l'execution du programme, lorsque l'utilisateur l'a demande (mode verbose/bavard)

	procedure progressionInit;
	-- Affiche l'etape : progression

	procedure progressionAnalyse;
	-- Affiche l'etape : analyse

	procedure progressionMeta;
	-- Affiche l'etape : affichage des informations (aide, version...)
  
  procedure progressionCoherence;
  -- Affiche l'etape : verification de la coherence des options

  procedure progressionGeneration;
  -- Affiche l'etape : generation
 
----------------------------------todo--------------------------------------
--Affiche un texte concernant une fonction qui n'a pas encore ete implementee

	procedure todo(t : String);
	-- Affiche que quelque chose n'est pas termine
	-- Utilise uniquement lors de la creation finale. Ne devrait jamais etre affiche lors d'une utilisation normale

-----------------------------------erreurs-----------------------------
-- Textes explicatifs des erreurs

  -- Erreur qui temoigne d'un bug dans le programme
  procedure txtErreurImpossible;

	-- L'option donnee est invalide
	procedure txtErreurOptionInconnue(o : string);

	-- Le numero de section donne n'eest pas valide (il n'est pas compris entre 1 et 8)
	procedure txtErreurNumeroSectionInvalideArgument(o : string);

	-- Le numero de section donne n'eest pas valide (il n'est pas compris entre 1 et 8)
	procedure txtErreurNumeroSectionInvalideAlbumRep(o : string);

	-- Erreur syntaxique : la ligne de commande ne respecte pas la grammaire
	procedure txtErreurSyntaxique(o : string);

	-- Le programme n'a pas reussi a ouvrir le fichier
	procedure txtErreurOuvertureImpossible(f : string);

	-- Le fichier specifie est introuvable
	procedure txtErreurFichierInexistant(f : string);

  -- Erreur lors de la lecture de l'entree standard
  procedure txtErreurListeFichiers(c : character);

  -- Erreur lors de l'ouverture du fichier
  procedure txtErreurOuvertureFichier(nom : string);

  -- Erreur lors de l'ouverture d'un repertoire
  procedure txtErreurOuvertureRepertoire(nom : string);

  -- Certaines options donnees ne sont pas coherentes entre elles
  procedure txtErreurCoherence;

  -- Erreur dans la chaine definissant la dimension des photos
  procedure txtErreurTaille(arg : string);

  -- L'unite demandee n'existe pas
  procedure txtErreurUnite(arg : string);

  -- La chaine attendue devrait etre un entier
  procedure txtErreurEntierInvalide(arg : string);

-----------------------------------avertissements-------------------------

  -- Une photo qui n'est pas au format eps a ete ignoree.
  procedure txtFichierNonEpsIgnore(nom : string);

  -- Un titre est definit alors que l'option sans-titre a deja ete appelee.
  procedure txtTitreSansTitre(titre : string);

  -- Un code html utilise est inconnu.
  procedure txtCodeHtmlInconnu(code : string);

  -- Un accent n'est pas connu.
  procedure txtAccentInconnu(accent : character);

	-- Affiche une proposition d'aide
	procedure txtProposeAide;

  private

	-- Affiche l'aide concernant la syntaxe d'appel
	procedure usage;

end texte;
