--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

package body trace is

	max_prof : integer := 0;

	procedure setProf(prof : integer) is
	begin
		max_prof := prof;
	end setProf;

   procedure tracer(sortie : File_Type ; prof : integer ; cmt : String) is
	-- Affiche un commentaire a l'ecran
	-- prof : profondeur du commentaire
	--    Les valeurs suivantes sont donnees a titre indicatif
	--    0 : Erreur
	--    1 : Warning
	--    2 : Mode bavard
	--    > 2 : debuggage
	-- cmt : le texte a afficher
	begin
		if (prof <= max_prof) then
			put_line(sortie, cmt );
		end if;
	end tracer;

  ---- Raccourcis ----
  -- Afficher un commentaire de debuggage
  procedure tracerDebug( prof : positive ; cmt : String ) is
  begin
    tracer(Standard_Error, prof + 2, cmt);
  end tracerDebug;

  -- Affichage d'une erreur
  procedure tracerErreur(texte : string) is
  begin
    tracer(Standard_Error, 0, texte);
  end tracerErreur;
  -- Affichage d'un avertissement
  procedure tracerAvertissement(texte : string) is
  begin
    tracer(Standard_Error, 1, texte);
  end tracerAvertissement;
  -- Affichage d'un message d'aide
  procedure tracerAide(texte : string) is
  begin
    tracer(Standard_Output, 0, texte);
  end tracerAide;
  -- Affichage d'un commentaire
  procedure tracerCommentaire(texte : string) is
  begin
    tracer(Standard_Error, 2, texte);
  end tracerCommentaire;


end trace;
