--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

-----------------------------------
--
--  Ce paquetage sert a gerer les traces d'execution
--  
-----------------------------------

with Ada.Text_Io;
use Ada.Text_Io;

package trace is

   -- Definit la profondeur jusqu'a laquelle on affiche les messages
   procedure setProf( prof : integer );

   -- Affiche un message (si la profondeur donnee est suffisament basse) sur la sortie d'erreurs
   procedure tracer( sortie : File_Type ; prof : integer ; cmt : String);

  ---- Raccourcis ----
  -- Afficher un commentaire de debuggage
  procedure tracerDebug( prof : positive ; cmt : String );
  -- Affichage d'une erreur
  procedure tracerErreur(texte : string);
  -- Affichage d'un avertissement
  procedure tracerAvertissement(texte : string);
  -- Affichage d'un message d'aide
  procedure tracerAide(texte : string);
  -- Affichage d'un commentaire
  procedure tracerCommentaire(texte : string);

end trace ;
