--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with erreurs, trace, fichier, structure, listefichiers, sectionrepertoire;
use erreurs, trace, fichier, structure, listefichiers, sectionrepertoire;

package body albumdesc is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

	procedure analyseAlbum(nom : string) is
    fichierLu : File_Type;
    secCourante : constant positive := section;
	begin
    section := sectionCourante;
		tracer(5, "Analyse du fichier '" & nom & "'");
    ouvrirLecture(nom, fichierLu);
    if not End_Of_File(fichierLu) then
      litLigne(fichierLu);
      axiome(fichierLu);
    end if;
    section := secCourante;
    fermer(fichierLu);
	end analyseAlbum;

  -- Renvoie true ssi la chaine 'ligne' commence par la chaine 'mot'
  function commence(ligne : string ; mot : string) return boolean is
  begin
    return ligne'length >= mot'length and then ligne(ligne'First..ligne'First+mot'length-1) = mot;
  end commence;
  function commence(ligne : unbounded_string ; mot : string) return boolean is
  begin
    return commence(to_string(ligne), mot);
  end commence;
  -- Renvoie la chaine "ligne" amputee de "mot", qui est cense la commencer
  function ampute(ligne : string ; mot : string) return unbounded_string is
  begin
    return to_unbounded_string(ligne(ligne'First + mot'length..ligne'last));
  end;
  function ampute(ligne : unbounded_string ; mot : string) return unbounded_string is
  begin
    return ampute(to_string(ligne), mot);
  end;

  procedure litLigne(f : File_Type) is
  begin
    if End_Of_File(f) then
    -- Fin du fichier
      ligne := Fin;
      return;
    end if;
    ligneBrute := to_unbounded_string(get_line(f));
    if commence(ligneBrute, "# ") then
      ligne := Titre1;
      suite := ampute(ligneBrute, "# ");
    elsif commence(ligneBrute, "## ") then
      ligne := Titre2;
      suite := ampute(ligneBrute, "## ");
    elsif commence(ligneBrute, "### ") then
      ligne := Titre3;
      suite := ampute(ligneBrute, "### ");
    elsif commence(ligneBrute, "#### ") then
      ligne := Titre4;
      suite := ampute(ligneBrute, "#### ");
    elsif commence(ligneBrute, "##### ") then
      ligne := Titre5;
      suite := ampute(ligneBrute, "##### ");
    elsif commence(ligneBrute, "###### ") then
      ligne := Titre6;
      suite := ampute(ligneBrute, "###### ");
    elsif commence(ligneBrute, "####### ") then
      ligne := Titre7;
      suite := ampute(ligneBrute, "####### ");
    elsif commence(ligneBrute, "A ") then
      ligne := Album;
      suite := ampute(ligneBrute, "A ");
    elsif commence(ligneBrute, "R ") then
      ligne := Repertoire;
      suite := ampute(ligneBrute, "R ");
    elsif commence(ligneBrute, "P ") then
      ligne := Photo;
      suite := ampute(ligneBrute, "P ");
    else
      ligne := Photo;
      suite := ampute(ligneBrute, "");
    end if;
    tracer(5, "Ligne lue : '" & to_string(ligneBrute) & "' suite='" & to_string(suite) & "'.");
  end litLigne;

	procedure axiome(f : File_Type) is
	begin
    tracer(5, "Mot reconnu : '" & token'image(ligne) & "'.");
    case ligne is
      when Titre1 =>
        Titre1(f);
        Axiome(f);
      when Titre2 =>
        Titre2(f);
        Axiome(f);
      when Titre3 =>
        Titre3(f);
        Axiome(f);
      when Titre4 =>
        Titre4(f);
        Axiome(f);
      when Titre5 =>
        Titre5(f);
        Axiome(f);
      when Titre6 =>
        Titre6(f);
        Axiome(f);
      when Titre7 =>
        Titre7(f);
        Axiome(f);
      when Album =>
        Album(f);
        Axiome(f);
      when Repertoire =>
        Repertoire(f);
        Axiome(f);
      when Photo =>
        Photo(f);
        Axiome(f);
      when Fin =>
        return;
      when others =>
        raise erreurAlbum;
    end case;
	end axiome;

  procedure Titre1(f : File_Type) is
  begin
    setSection(section + 0);
    sectionTrouvee(suite);
    litLigne(f);
  end Titre1;

  procedure Titre2(f : File_Type) is
  begin
    setSection(section + 1);
    sectionTrouvee(suite);
    litLigne(f);
  end Titre2;

  procedure Titre3(f : File_Type) is
  begin
    setSection(section + 2);
    sectionTrouvee(suite);
    litLigne(f);
  end Titre3;

  procedure Titre4(f : File_Type) is
  begin
    setSection(section + 3);
    sectionTrouvee(suite);
    litLigne(f);
  end Titre4;

  procedure Titre5(f : File_Type) is
  begin
    setSection(section + 4);
    sectionTrouvee(suite);
    litLigne(f);
  end Titre5;

  procedure Titre6(f : File_Type) is
  begin
    setSection(section + 5);
    sectionTrouvee(suite);
    litLigne(f);
  end Titre6;

  procedure Titre7(f : File_Type) is
  begin
    setSection(section + 6);
    sectionTrouvee(suite);
    litLigne(f);
  end Titre7;

  procedure Album(f : File_Type) is
  begin
    analyseListeFichiers(to_string(suite), album);
    litLigne(f);
  end Album;

  procedure Repertoire(f : File_Type) is
  begin
    analyseListeFichiers(to_string(suite), repertoire);
    litLigne(f);
  end Repertoire;

  procedure Photo(f : File_Type) is
  begin
    analyseListeFichiers(to_string(suite), photo);
    litLigne(f);
  end Photo;

end albumdesc;
