--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with Ada.strings.unbounded;
use Ada.strings.unbounded;

with trace, options, erreurs, texte, sectionrepertoire;
use trace, options, erreurs, texte, sectionrepertoire;

package body arguments is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  -- Analyse classique d'une grammaire LL1

	-- Prochain mot a analyser
	mot : token;

	-- Liste des regles de la grammaire
	procedure axiome is
	begin
		tracer(6, "Regle de 'axiome' ; mot suivant '" & tokenToString(mot) & "'");
		if (mot = Aide) then
			aide;
		elsif (mot = Diacritiques) then
			diacritiques;
		elsif (mot =  Version) then
			version;
	  else
			option;
		end if;
	end axiome;

	procedure option is
	begin
		tracer(6, "Regle de 'option' ; mot suivant '" & tokenToString(mot) & "'");
		if (mot = Fin) then
			null;
		elsif (mot = Photos) then
			photos;
			option;
		elsif (mot = Section) then
			section;
			option;
		elsif (mot = Album) then
			album;
			option;
		elsif (mot = Titre) then
			titre;
			option;
		elsif (mot = SansTitre) then
			titre;
			option;
		elsif (mot = Aide) then
			aide;
			option;
		elsif (mot = Version) then
			version;
			option;
		elsif (mot = Diacritiques) then
			diacritiques;
			option;
		elsif (mot = Bavard) then
			bavard;
			option;
		elsif (mot = Silencieux) then
			bavard;
			option;
		elsif (mot = Dimensions) then
			dimensions;
			option;
		elsif (mot = Nombre) then
			nombre;
			option;
		elsif (mot = Omettre) then
			omettre;
			option;
		elsif (mot = Repertoire) then
			repertoire;
			option;
    elsif (mot = Sortie) then
      sortie;
      option;
		elsif (mot = Verifier) then
			verifier;
			option;
    elsif (mot = Debug) then
      debug;
      option;
    else
			raise erreurSyntaxique;
		end if;
	end option;

	procedure sortie is
	begin
		tracer(6, "Regle de 'sortie' ; mot suivant '" & tokenToString(mot) & "'");
    if (mot = Sortie) then
			mot := motSuivant;
			if (mot /= Chaine) then
				raise erreurSyntaxique;
			end if;
      setNomSortie(to_string(motBrut));
      mot := motSuivant;
     else
       raise erreurSyntaxique;
     end if;
	end sortie;

  procedure photos is
  begin
		tracer(6, "Regle de 'photos' ; mot suivant '" & tokenToString(mot) & "'");
    if (mot = Photos) then
			mot := motSuivant;
			if (mot /= Chaine) then
				raise erreurSyntaxique;
			end if;
      photoTrouvee(motBrut);
      mot :=  motSuivant;
			listeFichiers(photo);
     else
       raise erreurSyntaxique;
     end if;
   end photos;

  procedure section is
    temp : character := valeur;
  begin
		tracer(6, "Regle de 'section' ; mot suivant '" & tokenToString(mot) & "'");
		if (mot = Section) then
			mot := motSuivant;
			if (mot /= chaine) then
				raise erreurSyntaxique;
			end if;
      sectionTrouvee(motBrut, character'pos(temp)-48);
			mot := motSuivant;
		else
			raise erreurSyntaxique;
		end if;
	end section;

  procedure album is
  begin
		tracer(6, "Regle de 'album' ; mot suivant '" & tokenToString(mot) & "'");
		if (mot = Album) then
      setSection(character'pos(valeur)-48);
			mot := motSuivant;
			if (mot /= chaine) then
				raise erreurSyntaxique;
			end if;
      albumTrouve(motBrut);
      mot :=  motSuivant;
			listeFichiers(album);
		else
			raise erreurSyntaxique;
		end if;
	end album;

  procedure titre is
  begin
		tracer(6, "Regle de 'titre' ; mot suivant '" & tokenToString(mot) & "'");
		if (mot = Titre) then
			mot := motSuivant;
			if (mot /= chaine) then
				raise erreurSyntaxique;
			end if;
      setTitre(to_string(motBrut));
			mot := motSuivant;
		elsif (mot = SansTitre) then
      pasDeTitre;
			mot := motSuivant;
		else
			raise erreurSyntaxique;
		end if;
   end titre;

  procedure aide is
  begin
		tracer(6, "Regle de 'aide' ; mot suivant '" & tokenToString(mot) & "'");
    if (mot = Aide) then
			demandeAide;
      mot := motSuivant;
    else
      raise erreurSyntaxique;
    end if;
   end aide;

  procedure version is
  begin
		tracer(6, "Regle de 'version' ; mot suivant '" & tokenToString(mot) & "'");
    if (mot = Version) then
      mot := motSuivant;
			demandeVersion;
    else
      raise erreurSyntaxique;
    end if;
   end version;

  procedure diacritiques is
  begin
		tracer(6, "Regle de 'diacritiques' ; mot suivant '" & tokenToString(mot) & "'");
    if (mot = Diacritiques) then
      mot := motSuivant;
			demandeDiacritiques;
    else
      raise erreurSyntaxique;
    end if;
 end diacritiques;

  procedure bavard is
  begin
		tracer(6, "Regle de 'bavard' ; mot suivant '" & tokenToString(mot) & "'");
     if (mot = Bavard) then
       mot := motSuivant;
		 elsif (mot = Silencieux) then
       mot := motSuivant;
     else
       raise erreurSyntaxique;
     end if;
   end bavard;

  procedure dimensions is
  begin
		tracer(6, "Regle de 'dimensions' ; mot suivant '" & tokenToString(mot) & "'");
    if (mot = Dimensions) then
			mot := motSuivant;
			if (mot /= chaine) then
				raise erreurSyntaxique;
			end if;
      tailleTrouvee(to_string(motBrut));
			mot := motSuivant;
    else
      raise erreurSyntaxique;
    end if;
   end dimensions;

  procedure nombre is
  begin
		tracer(6, "Regle de 'nombre' ; mot suivant '" & tokenToString(mot) & "'");
    if (mot = Nombre) then
	 		mot := motSuivant;
			if (mot /= chaine) then
				raise erreurSyntaxique;
			end if;
      if (motBrut = "auto") then
        nombreTrouve(0);
      else
        nombreTrouve(integer'value(to_string(motBrut)));
      end if;
			mot := motSuivant;
    else
      raise erreurSyntaxique;
    end if;

  exception
    when constraint_error =>
      txtErreurEntierInvalide(to_string(motBrut));
      raise erreurArg;

  end nombre;

  procedure omettre is
  begin
		tracer(6, "Regle de 'omettre' ; mot suivant '" & tokenToString(mot) & "'");
     if (mot = Omettre) then
       mot := motSuivant;
     else
       raise erreurSyntaxique;
     end if;
   end omettre;

  procedure repertoire is
  begin
		tracer(6, "Regle de 'repertoire' ; mot suivant '" & tokenToString(mot) & "'");
    if (mot = Repertoire) then
      setSection(character'pos(valeur)-48);
			mot := motSuivant;
			if (mot /= chaine) then
				raise erreurSyntaxique;
			end if;
      nouveauRepertoire(to_string(motBrut));
      mot :=  motSuivant;
      listeFichiers(repertoire);
    else
      raise erreurSyntaxique;
    end if;
  end repertoire;

	procedure listeFichiers(t : fichier) is
	begin
		tracer(6, "Regle de 'listeFichiers' ; mot suivant '" & tokenToString(mot) & "'");
		if (mot = chaine) then
      fichierTrouve(t, motBrut);
			mot := motSuivant;
			listeFichiers(t);
		else
			null; --cas "epsilon"
		end if;
	end listeFichiers;

	procedure verifier is
	begin
		tracer(6, "Regle de 'verifier' ; mot suivant '" & tokenToString(mot) & "'");
		if (mot = verifier) then
			mot := motSuivant;
		else
			raise erreurSyntaxique;
		end if;
	end verifier;

  procedure debug is
  begin
		tracer(6, "Regle de 'debug' ; mot suivant '" & tokenToString(mot) & "'");
		if (mot = debug) then
			mot := motSuivant;
			if (mot /= chaine) then
				raise erreurSyntaxique;
			end if;
      setProf(integer'value(to_string(motBrut)));
			mot := motSuivant;
		else
			raise erreurSyntaxique;
		end if;
	end debug;

	procedure analyseArguments is
	begin

		mot := motSuivant;
		axiome;

	exception
		when erreurSyntaxique =>
			txtErreurSyntaxique(to_string(motBrut));
			raise erreurArg;
    when erreurOuvertureFichier =>
      raise erreurArg;
	end analyseArguments;

end arguments ;
