--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
--
-- Analyse lexicale des arguments
--
----------------------------------------------------------------------------------

with Ada.Strings.Unbounded;
use Ada.Strings.Unbounded;

package lexical is

	-- Definition des mots du vocabulaire
	type token is (
		Fin, -- Fin de la ligne de commande atteinte
		Chaine, -- Chaine lue (aucun autre mot n'a ete reconnu)
    Sortie,
		Photos,
		Section,
		Album,
		Titre,
		SansTitre,
		Aide,
		Version,
		Diacritiques,
		Bavard,
		Silencieux,
		Dimensions,
		Nombre,
		Omettre,
		Repertoire,
		Verifier,
    Debug);

	-- valeur est modifiee par effet de bord par le fonction motSuivant. Elle contient des informations supplementaires sur le mot lu. 
	-- Dans les options de type '--album2 fichier.alb' (ou le '2' est un parametre optionnel), 'valeur' prend la valeur '2'.
	--
	-- Cette variable prends pour valeurs par defaut, a chaque appel de 'motSuivant', si aucune autre valeur ne lui est affectee, le caractere "3".
	valeur : character ;

	-- Mot lu, sans aucune interpretation
	-- Sert a afficher a quel endroit a ete trouvee une erreuer
	motBrut : Unbounded_String ;

	-- Renvoie le mot suivant
	function motSuivant return token;

	-- Tranforme un "token" en "string"
	-- Utile pour le debuggage
	function tokenToString(t : token) return String;

private

	function section(c : character) return boolean;

end lexical ;
