--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

---------------------------------------------------------------------
--
-- Ce paquetage gere la lecture et l'analyse d'une liste de fichiers.
--
-- Ainsi, les analyses syntaxique et lexicales seront confondues.
--
----------------------------------------------------------------------
with Ada.strings.unbounded;
use Ada.strings.unbounded;

with structure;
use structure;

package listeFichiers is


	-- Realise l'analyse de la liste 'l' de fichiers, sachant que les fichiers lus sont de type 't'
	procedure analyseListeFichiers(l : string ; t : fichier);

private 

	-- Cette procedure est executee lorsqu'un mot a ete trouve
	-- Ce mot peut eventuellement etre vide ; dans ce cas il est ignore
	procedure motTrouve(m : string);

  -- Type de fichier de l'analyse courante
  typ : fichier;
  -- Chaine lue
  liste : unbounded_String;


  -- Liste des regles de la grammaire
  procedure M(mot : string);
  procedure G(mot : out unbounded_string);
  procedure A(mot : out unbounded_string);
  procedure C(car : out unbounded_String);
  procedure L(car : out character);

  -- Liste des mots de la grammaire
  type token is (
    Guillemet,
    Apostrophe,
    Antislash,
    Espace,
    FinDeLigne,
    Normal -- Tous les autres
  );

  -- Caractere lu, avec interpretation
  carac : token;
  -- Affecte a "carac" le caractere suivant
  procedure carSuivant ;
  -- Caractere lu, sans interpretation
  carLu : character;
  -- Indice du dernier caractere lu
  indice : integer;

end listeFichiers;
