--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

-------------------------------------------------------------
--
-- Generation du fichier tex a partir de la structure de document fournie par le paquetage 'structure'
--
-------------------------------------
with Ada.Text_IO;
use Ada.Text_IO;

with options, structure, titre;
use options, structure, titre;

package generation is

  -- Genere le document
  procedure generationDocument;

  private

  -- Document en cours d'ecriture
  -- Si 'stdOut' est vrai, alors l'ecriture se fait sur la sortie standard, sinon dans le fichier 'f'
  stdOut : boolean;
  f : File_Type;

  -- Ecrit la chaine dans le fichier.
  procedure ecrire(chaine : string);
  -- Idem en ajoutant un Retour a la Ligne
  procedure ecrire_rl(chaine : string);
  procedure ecrire_rl;


  --Ecrit l'en-tete (la ligne "\documentclass{...}")
  procedure entete;

  --Ecrit le preambule du fichier
  procedure preambule;

  --Ecrit la ligne "\begin{document}
  -- et eventuellement "maketitle"
  procedure begin_document;

  -- Ecrit le corps du fichier
  procedure corps;

  -- Ecrit la derniere ligne du fichier
  procedure end_document;

  -- Ecrit un titre
  procedure titre(texte : string ; niveau : niveauDeTitre);

  --Place une photo
  procedure photo(legende, chemin : string);

end generation ;
