--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with Ada.Directories;
use Ada.Directories;

with texte, trace, albumdesc, erreurs, repertoire, entreestandard, diacritiques, options, taille;
use texte, trace, albumdesc, erreurs, repertoire, entreestandard, diacritiques, options, taille;

package body structure is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  procedure photoTrouvee(nom : unbounded_string) is
  begin
    photoTrouvee(to_string(nom));
  end photoTrouvee;
  procedure photoTrouvee(nom : string) is
  begin
    if entreeStandard(nom) then
      tracer(5, "Lecture sur l'entree standard");
      analyseEntreeStandard(photo);
    else
      if extension(nom)="eps" then
        tracer(3, "Photo '" & repertoireCourant & nom & "' trouvee.");
        ajoutePhoto(plan, repertoireCourant & nom, versLatex(Base_Name(nom)));
      else
        txtFichierNonEpsIgnore(nom);
      end if;
    end if;
  end photoTrouvee;

  procedure albumTrouve(nom : unbounded_string) is
  begin
    albumTrouve(to_string(nom));
  end albumTrouve;
  procedure albumTrouve(nom : string) is
    courant : constant sectoire := sectoireCourant;
  begin
    if entreestandard(nom) then
      tracer(5, "Lecture sur l'entree standard");
      analyseEntreeStandard(album);
    else
      tracer(3, "Album '" & repertoireCourant & nom & "' trouve.");
      analyseAlbum(nom);
    end if;
    setSectoire(courant);
  end albumTrouve;

  procedure repertoireTrouve(nom : unbounded_string) is
  begin
    repertoireTrouve(to_string(nom));
  end repertoireTrouve;
  procedure repertoireTrouve(nom : string) is
    courant : constant sectoire := sectoireCourant;
  begin
    ajouteSection;
    nouveauRepertoire(nom);
    setSectoire(courant);
  end;

  procedure nouveauRepertoire(nom : string) is
    courant : constant sectoire := sectoireCourant;
  begin
    sectionTrouvee(Base_Name(nom), sectionCourante);
    if entreestandard(nom) then
      tracer(5, "Lecture sur l'entree standard");
      analyseEntreeStandard(repertoire);
    else
      ajouteRepertoire(nom);
      tracer(3, "Repertoire '" & nom & "' trouve.");
      analyseRepertoire(nom);
    end if;
    setSectoire(courant);
  end nouveauRepertoire;

  procedure fichierTrouve(t : fichier ; nom : unbounded_string) is
  begin
    fichierTrouve(t, to_string(nom));
  end fichierTrouve;
  procedure fichierTrouve(t : fichier ; nom : string) is
  begin
    case t is
      when photo => photoTrouvee(nom);
      when album => albumTrouve(nom);
      when repertoire => repertoireTrouve(nom);
      when others => raise erreurImpossible;
    end case;
  end fichierTrouve;

  function entreeStandard(nom : string) return boolean is
  begin
    -- Si 'nom' /= '-', alors la chaine ne correspond pas a la lecture de l'entree satndard
    -- Si 'nom'='-', mais que l'entree standard a deja ete lue, alors on ne lit pas l'entree standard
    if nom /= "-" or entreeStandardLue then
      return false;
    end if;
    entreeStandardLue := true;
    return true;
  end entreeStandard;

  procedure sectionTrouvee(nom : unbounded_string) is
  begin
    sectionTrouvee(nom, sectionCourante);
  end sectionTrouvee;
  procedure sectionTrouvee(nom : string) is
  begin
    sectionTrouvee(nom, sectionCourante);
  end sectionTrouvee;
  procedure sectionTrouvee(nom : unbounded_string ; niveau : positive) is
  begin
    sectionTrouvee(to_string(nom), niveau);
  end sectionTrouvee;
  procedure sectionTrouvee(nom : string ; niveau : positive) is
  begin
    tracer(3, "Section de niveau " & positive'image(niveau) & " trouvee : '" & nom & "'.");
    ajouteSection(plan, versLatex(nom), niveau);

  exception
    when erreurNumeroSectionInvalide =>
      txtErreurNumeroSectionInvalideAlbumRep(nom);
      raise erreurCreation;

  end sectionTrouvee;

  -- Place dans le plan du document une indication de changement de taille des photos
  procedure tailleTrouvee(taille : string) is
    hori, vert : unbounded_string;
  begin
    -- Analysons la chaine
    analyseTaille(taille, hori, vert);
    -- Commencons par regler la taille dans les options
    setTaille(hori, vert);
    -- Puis ajoutons la taille a la structure du document
    ajouteTaille(plan, to_string(hori), to_string(vert));
  end tailleTrouvee;

  -- Place dans la plan du document une indication de changement du nombre de photos par ligne
  procedure nombreTrouve(n : integer) is
  begin
    setNombre(n);
    ajouteNombre(plan, n);
  end nombreTrouve;


  -- Renvoie 'true' ssi le prochain element de la liste est le type demande
  function estTitre return boolean is
  begin
    return estTitre(plan);
  end estTitre;
  function estPhoto return boolean is
  begin
    return estPhoto(plan);
  end estPhoto;
  function estTaille return boolean is
  begin
    return estTaille(plan);
  end estTaille;
  function estNombre return boolean is
  begin
    return estNombre(plan);
  end estNombre;

  -- Renvoie les champs demandes.
  -- Precondition : ce champ existe. L'erreur "erreur inconnue" est levee s'il n'existe pas
  function photoLegende return string is
  begin
    return photoLegende(plan);
  end photoLegende;
  function photoChemin return string is
  begin
    return photoChemin(plan);
  end photoChemin;
  function titreTexte return string is
  begin
    return titreTexte(plan);
  end titreTexte;
  function titreNiveau return niveauDeTitre is
  begin
    return titreNiveau(plan);
  end titreNiveau;
  function tailleHori return string is
  begin
    return tailleHori(plan);
  end tailleHori;
  function tailleVert return string is
  begin
    return tailleVert(plan);
  end tailleVert;
  function nombreNombre return integer is
  begin
    return nombreNombre(plan);
  end nombreNombre;

  procedure suivant is
  begin
    suivantdestructeur(plan);
  end suivant;

  function fini return boolean is
  begin
    return estVide(plan);
  end fini;

end structure;
