--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

--------------------------------------------------
--
-- Ce paquetage sert a gerer la structure du document final, sous la forme d'une liste
--
--------------------------------------------------
with Ada.strings.unbounded;
use Ada.strings.unbounded;

with sectionrepertoire, typedocument, titre;
use sectionrepertoire, typedocument, titre;

package structure is

  -- Caracterise, pour certaines fonctions, ce que nous sommes en train d'analyser
  type fichier is (
    indefini,
    photo,
    repertoire,
    album
  );

  ------------------------------- Mutateurs ------------------

  -- Effectue les actions necessaires pour integrer la photo a la structure
  procedure photoTrouvee(nom : unbounded_string);
  procedure photoTrouvee(nom : string);
  -- Effectue les actions a executer lorsqu'un album a ete trouve
  procedure albumTrouve(nom : unbounded_string);
  procedure albumTrouve(nom : string);
  -- Effectue les actions a executer lorsqu'un repertoire a ete trouve
  procedure repertoireTrouve(nom : unbounded_string);
  procedure repertoireTrouve(nom : string);
  procedure nouveauRepertoire(nom : string);
  -- Appelle l'une des fonctions ci-dessus, en fonction du type de fichier donne
  procedure fichierTrouve(t : fichier ; nom : unbounded_string);
  procedure fichierTrouve(t : fichier ; nom : string);

  -- Effectue le necessaire lorsqu'une section a ete trouvee
  procedure sectionTrouvee(nom : unbounded_string);
  procedure sectionTrouvee(nom : unbounded_string ; niveau : positive);
  procedure sectionTrouvee(nom : string);
  procedure sectionTrouvee(nom : string ; niveau : positive);

  -- Place dans le plan du document une indication de changement de taille des photos
  procedure tailleTrouvee(taille : string);

  -- Place dans la plan du document une indication de changement du nombre de photos par ligne
  procedure nombreTrouve(n : integer);


  -- Supprime le premier element
  procedure suivant;

  ------------------------- Accesseurs ---------------------------
  
  -- Renvoie 'true' ssi la fin du document est atteinte
  function fini return boolean;

  -- Renvoie 'true' ssi le prochain element de la liste est le type demande
  function estTitre return boolean;
  function estPhoto return boolean;
  function estTaille return boolean;
  function estNombre return boolean;

  -- Renvoie les champs demandes.
  -- Precondition : ce champ existe. L'erreur "erreur inconnue" est levee s'il n'existe pas
  function photoLegende return string;
  function photoChemin return string;
  function titreTexte return string;
  function titreNiveau return niveauDeTitre;
  function tailleHori return string;
  function tailleVert return string;
  function nombreNombre return integer;
  
private

  -- Vaut 'true' ssi l'entree standard a deja ete lue
  entreeStandardLue : boolean := false;

  -- Verifie s'il faut appeler la lecture de l'entree standard ou non
  function entreeStandard(nom : string) return boolean;

  plan : document := documentVide;

end structure;
