----------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
----------------------------------------------------------------------

with trace;
use trace;

package body tailleCourante is


  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  -- Définit la taille courante
  procedure setTailleCourante(hori, vert : unbounded_string) is
  begin
    horizontal := hori;
    vertical := vert;
  end setTailleCourante;
  procedure setTailleCourante(hori, vert : string) is
  begin
    setTailleCourante(to_unbounded_string(hori), to_unbounded_string(vert));
  end setTailleCourante;
  -- Définit le nombre courant
  procedure setNombreCourant(n : integer) is
  begin
    nombre := n;
  end setNombreCourant;

  -- Retourne la taille courante
  procedure getTailleCourante(hori, vert : out unbounded_string) is
  begin
    hori := horizontal;
    vert := vertical;
  end getTailleCourante;
  -- Retourne le nombre courant
  function getNombreCourant return integer is
  begin
    return nombre;
  end getNombreCourant;

  -- Retourne la chaine LaTeX correspondant a la taille courante
  function getTailleCourante return string is
  begin
    if (horizontal = "" and vertical = "") then
      return "";
    elsif (horizontal = "") then
      return "[height=" & to_string(vertical) & "]";
    elsif (vertical = "") then
      return "[width=" & to_string(horizontal) & "]";
    else
      return "[width=" & to_string(horizontal) & ",height=" & to_string(vertical) & "]";
    end if;
  end getTailleCourante;

end tailleCourante;
