--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

------------------------------------------------------
--
-- Gere le remplacement des diacritiques par le code LaTeX correspondant
--
-----------------------------------------------------

with Ada.strings.unbounded;
use Ada.strings.unbounded;

package diacritiques is

  -- Converti la chaine en protegeant les caracteres speciaux et en remplacant les diacritiques par la chaine LaTeX correspondante
  function versLatex(chaine : unbounded_string) return string;
  function versLatex(chaine : string) return string;

private

  -- Analyse de la grammaire LL1 decrite dans le fichier "doc/grammaire/diacritiques.txt"
  
  -- Chaine a analyser
  chaineAnalysee : unbounded_string;
  -- Indice du Caractere courant
  indiceCourant : integer;
  -- Type token
  type token is (
    alphaNum, -- Caractere alphanumerique sans accents, plus l'espace et l'apostrophe
    protege, -- Caractere protege en Latex
    tiret, -- Le caractere est un tiret
    tiretBas, -- Un tiriet bas _
    accent, -- Caractere avec accent (en realite, tout sauf les caracteres deja listes)
    finDeLigne
  );
  -- Caractere courant
  courant : token;
  caractere : character;
  -- Passe au caractere suivant
  procedure carSuivant;


  -- Regles de la grammaire
  function axiome return string;
  function entreTirets return string;

  -- Renvoie vrai ssi le caractere est un caractere protege en LaTeX
  function protege(car : character) return boolean;
  -- Renvoie vrai ssi le caractere est un caractere alphanumerique
  function alphanum(car : character) return boolean;
  -- Renvoie vrai ssi le caractere est un caractere avec accent
  function accent(car : character) return boolean;

end diacritiques ;
