--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with Ada.Text_IO, Ada.IO_Exceptions, Ada.Directories;
use Ada.Text_IO, Ada.Directories;

with erreurs, texte, trace;
use erreurs, texte, trace;

package body fichier is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  procedure ouvrirLecture(nom : string ; f : out File_Type) is
  begin
    ouvrir(nom, f, In_File);
  end ouvrirLecture;

  procedure fermer(f : in out File_Type) is
  begin
    if (is_Open(f)) then
      Close(f);
    end if;
  end fermer;

  procedure creer(nom : string ; stdOut : out boolean ; f : out File_Type) is
  begin
    if (nom="") then
      stdOut := true;
    else
      if (exists(nom) and then Kind(nom) = Directory) then
        -- Le fichier est-il un repertoire ?
        txtErreurOuvertureFichier(nom);
        raise erreurOuvertureFichier;
      end if;
      Create(f, Out_File, nom) ; 
      stdOut := false;
    end if;
  exception
    when ADA.IO_EXCEPTIONS.USE_ERROR => 
      txtErreurOuvertureFichier(nom);
      raise erreurOuvertureFichier;
    when ADA.IO_EXCEPTIONS.DEVICE_ERROR =>
      txtErreurOuvertureFichier(nom);
      raise erreurOuvertureFichier;
  end creer;

  procedure ouvrir(nom : string ; f : out File_Type ; mode : File_Mode) is
  begin
    if Kind(nom) = Directory then
      -- Le fichier est-il un repertoire ?
      txtErreurOuvertureFichier(nom);
      raise erreurOuvertureFichier;
    end if;
    Open(f, mode, nom) ; 
  exception
    when ADA.IO_EXCEPTIONS.USE_ERROR => 
      txtErreurOuvertureFichier(nom);
      raise erreurOuvertureFichier;
    when ADA.IO_EXCEPTIONS.DEVICE_ERROR =>
      txtErreurOuvertureFichier(nom);
      raise erreurOuvertureFichier;
    when ADA.IO_EXCEPTIONS.NAME_ERROR =>
      txtErreurOuvertureFichier(nom);
      raise erreurOuvertureFichier;
  end ouvrir;

end fichier;
