--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

-------------------------------------
--
-- Ce paquetage gere les options globales
--
---------------------------------------

with Ada.strings.unbounded;
use Ada.strings.unbounded;

package options is

	-- Initialise les options globales
	procedure initOptions;
  -- Place les options non precisees par l'utilisateur a leur valeur par defaut
  procedure defautOptions;

  --------------------------------------------------------------
  ------------ Affichage  d'informations -----------------------
  ------------ aide version diacritiques -----------------------
  --------------------------------------------------------------

	-- Les six fonctions suivantes correspondent aux affichages d'information, sans execution reelle du programme (affichage de l'aide, de la verison, de la liste des diacritiques).
	-- Pour chacune d'entre elle, la version "demande*" correspond a la demande (l'utilisateur DEMANDE ...), et la version "affiche*" correspond a la question  (faut-il afficher ... ?).
	procedure demandeAide;
	function afficheAide return boolean;
	procedure demandeVersion;
	function afficheVersion return boolean;
	procedure demandeDiacritiques;
	function afficheDiacritiques return boolean;

  --------------------------------------------------------------
  ----------- Nom du fichier de sortie -------------------------
  --------------------------------------------------------------
  -- Definit le nom du fichier de sortie
  procedure setNomSortie(n : string);
  -- Retourne le nom du fichier de sortie
  function getNomSortie return string;

  --------------------------------------------------------------
  ----------- Nombre de photos par ligne -----------------------
  --------------------------------------------------------------
  -- Definit le nombre de photos par ligne
  procedure setNombre(n : integer);
  -- Retourne le nombre de photos par ligne
  function getNombre return integer;

  --------------------------------------------------------------
  ----------- Titre --------------------------------------------
  --------------------------------------------------------------
  -- Definit le titre
  procedure setTitre(t : string);
  -- Specifie que l'on ne veut pas de titre
  procedure pasDeTitre;
  -- Demande si le titre doit etre affiche ou nom
  function afficheTitre return boolean;
  -- Renvoie le titre
  function getTitre return string;


  --------------------------------------------------------------
  ----------- Statistiques sur les photos ----------------------
  --------------------------------------------------------------
  -- Verifie le niveau d'une section
  procedure verifieNiveau(niveau : positive);
  -- Donne le niveau minimum atteint par une section
  function niveauMin return positive;
  
  --------------------------------------------------------------
  ----------- Taille des photos --------------------------------
  --------------------------------------------------------------
  -- Définit la taille horizontale et verticale des photos.
  -- Une chaine vide signifie : taille automatique
  procedure setTaille(hori, vert : unbounded_string);

  private

	-- Vaut true ssi de l'aide est demandee
	aideDemande : boolean := false;
	-- Vaut true ssi l'affichage de la version est demandee
	versionDemande : boolean := false;
	-- Vaut true ssi l'affichage des diacritiques est demandee
	diacritiquesDemande : boolean := false;


  -- Nom du fichier de sortie
  nom : unbounded_string;

  -- Nombre de photos par ligne
  -- O = on remplit la ligne tant qu'on peut
  nombre : integer;

  -- Titre du document, et booleens specifiant respectivement si un titre a ete definit et si l'option sans-titre a ete appelee.
  titre : unbounded_string;
  avecTitre : boolean := false;
  sansTitre : boolean := false;

  -- Niveau minimal des sections
  niveauSectionMin : positive := 7;

  -- Plusieurs definition de taille
  tailleModifiee : boolean := false;
  tailleVariable : boolean := false;
  horizontal, vertical : unbounded_string := to_unbounded_string("");

end options ;
