#!/bin/bash

######################################################################
# ajouteLicence - Copyright 2007-2008 Louis Paternault
# 
# ajouteLicence is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# ajouteLicence is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with ajouteLicence.  If not, see <http://www.gnu.org/licenses/>.
######################################################################

# Ce script ajoute la licence au debut d'un fichier.
# Le premier argument est la marque de commentaire du fichier en question, les suivants les fichiers a traiter.

marque=$1
shift

# Copie de la licence en une forme commentee
echo "--------------------------------------------------------------------------------" > .resume
while read i
do
  echo "${marque} ${i}"
done < "../doc/licence/resume.txt" >> .resume
echo "--------------------------------------------------------------------------------" >> .resume
echo "" >> .resume

# Traitement de chaque fichier
while [ $# != 0 ]
do
  ancien=$1
  temporaire=`basename $ancien`.tmp
  cat .resume $ancien > $temporaire
  mv $temporaire $ancien
  shift
done

# Suppression du fichier temporaire
rm .resume
