--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

--------------------------------------------------------------
--
-- Lance les differentes etapes du programme les unes apres les autres
--
--------------------------------------------------------------

package plan is

	-- Execute l'etape suivante, et renvoie "vrai" ssi la derniere etape a ete atteinte.
	function etapeSuivante return boolean;

	-- Appelle la fonction du paquetage approprie pour faire l'etape d'initialisation des variables
	procedure lanceInitialisation;

	-- Appelle la fonction du paquetage approprie pour faire l'etape d'analyse des arguments
	procedure lanceAnalyse;

  -- Fait quelques verifications sur les options passees en argument
  procedure lanceCoherence;

  -- Appelle la fonction du paquetage approprie pour faire l'etape de generation du fichier LaTeX
  procedure lanceGeneration;

	-- Appelle, si besoin est, les methodes d'affichage de l'aide, de la liste des diacritiques, ou de la version
	-- Renvoie true ssi il faut s'arreter (ie si on a affiche l'une des choses)
	function lanceMeta return boolean;

  private

  -- Liste des etapes a effectuer.
  -- Ce devrait etre un arbre plutot qu'une liste, car apres lanalyse, nous effectuons soit l'affichage des metaInformations, soit la suite des etapes.
  type etape is (
    initialisation,
    analyse,
    metaInformations,
    coherence,
    generation,
    fin
  );

	-- Etape du programme a laquelle on se trouve
  etape_courante : etape := initialisation;

end plan ;
