--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with trace;
use trace;

package body sectionrepertoire is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  -- Retourne le sectoire courant
  function sectoireCourant return sectoire is
  begin
    return courant;
  end sectoireCourant;

  -- Retourne le repertoire courant
  function repertoireCourant return string is
  begin
    return to_string(courant.repertoire);
  end repertoireCourant;

  -- Retourne la section courante
  function sectionCourante return positive is
  begin
    return courant.section;
  end sectionCourante;

  -- Place le sectoire courant
  procedure setSectoire(s : sectoire) is
  begin
    courant := s;
  end setSectoire;

  -- Ajoute un chemin au repertoire courant
  procedure ajouteRepertoire(rep : string) is
  begin
    courant.repertoire := to_unbounded_string(to_string(courant.repertoire) & rep & "/");
  end ajouteRepertoire;

  -- Ajoute des niveaux a la section courante
  procedure ajouteSection(n : positive := 1) is
  begin
    courant.section := courant.section + n;
  end ajouteSection;

  -- Definit la section courante
  procedure setSection(n : positive) is
  begin
    courant.section := n;
  end setSection;

  -- Definit le repertoire courant
  procedure setRepertoire(rep : string) is
  begin
    courant.repertoire := to_unbounded_string(rep);
  end setRepertoire;

end sectionrepertoire;
