--------------------------------------------------------------------------------
-- Trombi - Copyright 2007-2008 Louis Paternault
-- 
-- This file is part of Trombi.
-- 
-- Trombi is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- Trombi is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with Trombi.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------

with trace, erreurs, options;
use trace, erreurs, options;

package body typedocument is

  ----------------------------------------
  -- Gere les commentaires de debuggage --
  profMax : integer := 1;
  procedure tracer(prof : positive ; chaine : string) is
  begin
    if prof <= profMax then
      tracerDebug(prof, chaine);
    end if;
  end tracer;
  ----------------------------------------

  function documentVide return document is
  begin
    return listeVide;
  end documentVide;

  procedure ajoutePhoto(doc : in out document ; chemin, nom : string) is
  begin
    ajouteQueue(element'(legenre => photo, legende => to_unbounded_string(nom), chemin => to_unbounded_string(chemin)), doc);
  end ajoutePhoto;

  procedure ajouteSection(doc : in out document ; nom : string ; niveau : positive) is
  begin
    verifieNiveau(niveau);
    ajouteQueue(element'(legenre => titre, texte => to_unbounded_string(nom), niveau => niveauDeTitre'val(niveau - 1)), doc);
  end ajouteSection;

  -- Ajoute une definition de taille des photos au document
  procedure ajouteTaille(doc : in out document ; hori : string ; vert : string) is
  begin
    ajouteQueue(element'(legenre => taille, hori => to_unbounded_string(hori), vert => to_unbounded_string(vert)), doc);
  end ajouteTaille;

  -- Ajoute une definition de nombre de photos par ligne au document
  procedure ajouteNombre(doc : in out document ; n : integer) is
  begin
    ajouteQueue(element'(legenre => nombre, nombre => n), doc);
  end ajouteNombre;

  procedure affiche(doc : document ; n : integer := 3) is
  begin
    if estVide(doc) then
      null;
    else
      case tete(doc).leGenre is
        when photo =>
          tracer(n, "Photo " & photoLegende(doc) & " " & photoChemin(doc));
        when titre =>
          tracer(n, "Titre " & niveauDeTitre'image(titreNiveau(doc)) & " " & titreTexte(doc));
        when taille =>
          tracer(n, "Taille " & tailleHori(doc) & " " & tailleVert(doc));
        when nombre =>
          tracer(n, "Nombre " & integer'image(nombreNombre(doc)));
        when aucun =>
          tracer(3, "Element nul. Etrange...");
      end case;
      affiche(suite(doc));
    end if;
  end affiche;

  function leGenre(e : element) return genre is
  begin
    return e.leGenre;
  end leGenre;


  -- Renvoie les champs demandes.
  -- Precondition : ce champ existe. L'erreur "erreur inconnue" est levee s'il n'existe pas
  function photoLegende(e : element) return string is
  begin
    return to_string(e.legende);
  exception
    when constraint_error =>
      raise erreurImpossible;
  end photoLegende;
  function photoLegende(doc : document) return string is
  begin
    return photoLegende(tete(doc));
  end photoLegende;

  function photoChemin(e : element) return string is
  begin
    return to_string(e.chemin);
  exception
    when constraint_error =>
      raise erreurImpossible;
  end photoChemin;
  function photoChemin(doc : document) return string is
  begin
    return photoChemin(tete(doc));
  end photoChemin;

  function titreTexte(e : element) return string is
  begin
    return to_string(e.texte);
  exception
    when constraint_error =>
      raise erreurImpossible;
  end titreTexte;
  function titreTexte(doc : document) return string is
  begin
    return titreTexte(tete(doc));
  end titreTexte;

  function titreNiveau(e : element) return niveauDeTitre is
  begin
    return e.niveau;
  exception
    when constraint_error =>
      raise erreurImpossible;
  end titreNiveau;
  function titreNiveau(doc : document) return niveauDeTitre is
  begin
    return titreNiveau(tete(doc));
  end titreNiveau;

  function tailleHori(e : element) return string is
  begin
    return to_string(e.hori);
  end tailleHori;
  function tailleHori(doc : document) return string is
  begin
    return tailleHori(tete(doc));
  end tailleHori;
  function tailleVert(e : element) return string is
  begin
    return to_string(e.vert);
  end tailleVert;
  function tailleVert(doc : document) return string is
  begin
    return tailleVert(tete(doc));
  end tailleVert;
  function nombreNombre(e : element) return integer is
  begin
    return e.nombre;
  end nombreNombre;
  function nombreNombre(doc : document) return integer is
  begin
    return nombreNombre(tete(doc));
  end nombreNombre;

  -- Renvoie 'true' ssi le prochain element de la liste est le type demande
  function estTitre(doc : document) return boolean is
  begin
    return leGenre(tete(doc)) = titre;
  end estTitre;
  function estPhoto(doc : document) return boolean is
  begin
    return leGenre(tete(doc)) = photo;
  end estPhoto;
  function estTaille(doc : document) return boolean is
  begin
    return leGenre(tete(doc)) = taille;
  end estTaille;
  function estNombre(doc : document) return boolean is
  begin
    return leGenre(tete(doc)) = nombre;
  end estNombre;

  function estVide(doc : document) return boolean is
  begin
    return maListe.estVide(dliste(doc));
  end estVide;

  procedure suivantdestructeur(doc : in out document) is
  begin
    doc := suiteDestructive(doc);
  end suivantdestructeur;

end typedocument;
