// -*- Mode: Java; indent-tabs-mode: nil; c-basic-offset: 4; -*-
/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Ant", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
// $Header: /cvsroot/ant-doxygen/ant_task/test/src/test/org/doxygen/tools/DoxygenTest.java,v 1.5.4.3 2004/01/31 01:40:33 akkumar Exp $
package test.org.doxygen.tools;

import org.doxygen.tools.DoxygenTask;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.Test;
//import org.apache.tools.ant.BuildException;

import java.io.File;
import java.util.Map;

/** Test case for Ant task for Doxygen.
 *
 *  @author <a href="mailto:akkumar@users.sourceforge.net">Karthik Kumar</a>
 *  @version $Revision: 1.5.4.3 $
 *
 * @since Ant-Doxygen release 1.2
 *
 */
public class DoxygenTest extends TestCase {

    /** This is the instance of the task used by all the test cases.
     */
    private DoxygenTask doxygenTask;

    /** Output Directory root of the doxygen utility.  All directories
     *  for html and latex are created by doxygen under this.
     */
    private static final String OUTPUT_DIR =
        "test" + File.separator + "doc";

    /** Location where Doxygen will generate the HTML
     *  documentation.
     */
    private final File htmlDir =
        new File(OUTPUT_DIR + File.separator + "html");

    /** Location where Doxygen would normally generate the Latex
     *  documentation.
     */
    private final File latexDir =
        new File(OUTPUT_DIR + File.separator + "latex");

    /** Location where the test case documentation runs will be placed
     *  (and subsequently cleaned up).
     */
    private final File outputDir = new File(OUTPUT_DIR);





    //----------------------------------------------------------------------
    /** Sets up a new instance of the task before applying tests. The
     *  only difference between this test and the minimalist
     *  Ant-Doxygen example is that the OUTPUT_DIRECTORY is set to
     *  ./test/doc.  All other defaults are accepted.
     */
    public final void setUp() {
         doxygenTask = new DoxygenTask();
         doxygenTask.setConfig("OUTPUT_DIRECTORY", OUTPUT_DIR);
    }




    //----------------------------------------------------------------------
    /** Destroys the task instance created. */
    public final void tearDown() {
        doxygenTask = null;
        deleteDir(outputDir);
    }





    //----------------------------------------------------------------------
    /** Returns the TestSuite defined by this class.
     *
     *  @return Returns a Test suite
     *
     */
    public static final Test suite() {
        return new TestSuite(DoxygenTest.class);
    }





    //----------------------------------------------------------------------
    /** Test case for generating html and not generting latex.
     *
     *  @since ant-doxygen release 1.2
     *
     */
    public final void testHtmlOnly() {
        doxygenTask.execute();
        assertEquals(true, htmlDir.exists());
        assertEquals(false, latexDir.exists());
        deleteDir(htmlDir);
    }





    //----------------------------------------------------------------------
    /** This test case ensures that the default attributes injected by
     *  the DoxygenTask constructor are stable (e.g. testable).  The
     *  sole exception is PROJECT_NAME, which depends on an Ant
     *  runtime environment that we do not construct in this test
     *  suite.
     *
     *  \note This satisfies the test case described in the
     *  DoxygenTask constructor.
     *
     *  @see org.doxygen.tools.DoxygenTask
     */
    public final void testDoxygenConstructor() {
        Map map = doxygenTask.getTaskAttributes();
        validateProperty(map, "DETAILS_AT_TOP", "YES");
        validateProperty(map, "EXPAND_TOC", "YES");
        validateProperty(map, "FILE_PATTERNS", "*.java");
        validateProperty(map, "GENERATE_LATEX", "NO");
        validateProperty(map, "HAVE_DOT", "NO");
        validateProperty(map, "HIDE_UNDOC_MEMBERS", "YES");
        validateProperty(map, "INLINE_SOURCE", "YES");
        validateProperty(map, "INPUT", "src");
        validateProperty(map, "OPTIMIZE_OUTPUT_JAVA", "YES");
        validateProperty(map, "OUTPUT_DIRECTORY", OUTPUT_DIR);
        validateProperty(map, "QUIET", "YES");
        validateProperty(map, "RECURSIVE", "YES");
        validateProperty(map, "SOURCE_BROWSER", "YES");
    }





    //----------------------------------------------------------------------
    /** This is a helper method for testDoxygenConstructor().  This will
     *  assert that the tree map contains the specified key/value pair.
     *
     *  @param map is the TreeMap to be interrogated.
     *  @param key is the element being searched for in map.
     *  @param val is the value being compared to once the key is
     *  found in map.
     *
     */
    private void validateProperty(final Map map,
                                  final String key,
                                  final String val) {
        assertEquals("Default attribute " + key + ": ",
                     true,
                     map.containsKey(key)
                     && ((String) map.get(key)).equals(val));
    }





    //----------------------------------------------------------------------
    /** Recursively deletes the directory tree under File f.
     *
     * @param f Directory tree root that needs to be destroyed
     **/
    private void deleteDir (final File f) {
        File[] contents = f.listFiles();
        for (int i = 0; (i < contents.length); i++) {
            if (!contents[i].delete()) {
                System.out.println("Unable to delete file "
                                   + "[" + contents[i] + "]");
            }
        }
        if (!f.delete()) {
            System.out.println("Unable to delete directory [" + f + "]");
        }
    }
}
