/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class Zip
extends MatchingTask {
    protected File zipFile;
    private File baseDir;
    protected Hashtable entries = new Hashtable();
    private Vector groupfilesets = new Vector();
    private Vector filesetsFromGroupfilesets = new Vector();
    protected String duplicate = "add";
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    private boolean doFilesonly = false;
    protected String archiveType = "zip";
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    protected Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    private boolean addingNewFiles = false;
    private String encoding;

    public void setZipfile(File zipFile) {
        this.setDestFile(zipFile);
    }

    public void setFile(File file) {
        this.setDestFile(file);
    }

    public void setDestFile(File destFile) {
        this.zipFile = destFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCompress(boolean c) {
        this.doCompress = c;
    }

    public void setFilesonly(boolean f) {
        this.doFilesonly = f;
    }

    public void setUpdate(boolean c) {
        this.doUpdate = c;
        this.savedDoUpdate = c;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void addZipfileset(ZipFileSet set) {
        this.filesets.addElement(set);
    }

    public void addZipGroupFileset(FileSet set) {
        this.groupfilesets.addElement(set);
    }

    public void setDuplicate(Duplicate df) {
        this.duplicate = df.getValue();
    }

    public void setWhenempty(WhenEmpty we) {
        this.emptyBehavior = we.getValue();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0 && this.groupfilesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        File renamedFile = null;
        this.addingNewFiles = true;
        this.doUpdate = this.doUpdate && this.zipFile.exists();
        int i = 0;
        while (i < this.groupfilesets.size()) {
            this.log("Processing groupfileset ", 3);
            FileSet fs = (FileSet)this.groupfilesets.elementAt(i);
            DirectoryScanner scanner = fs.getDirectoryScanner(this.project);
            String[] files = scanner.getIncludedFiles();
            File basedir = scanner.getBasedir();
            int j = 0;
            while (j < files.length) {
                this.log("Adding file " + files[j] + " to fileset", 3);
                ZipFileSet zf = new ZipFileSet();
                zf.setSrc(new File(basedir, files[j]));
                this.filesets.addElement(zf);
                this.filesetsFromGroupfilesets.addElement(zf);
                ++j;
            }
            ++i;
        }
        Vector<DirectoryScanner> dss = new Vector<DirectoryScanner>();
        if (this.baseDir != null) {
            dss.addElement(this.getDirectoryScanner(this.baseDir));
        }
        int i2 = 0;
        while (i2 < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i2);
            dss.addElement(fs.getDirectoryScanner(this.project));
            ++i2;
        }
        int dssSize = dss.size();
        Object[] scanners = new FileScanner[dssSize];
        dss.copyInto(scanners);
        boolean success = false;
        try {
            try {
                if (this.isUpToDate((FileScanner[])scanners, this.zipFile)) {
                    Object var17_12 = null;
                    this.cleanUp();
                    return;
                }
                if (this.doUpdate) {
                    FileUtils fileUtils = FileUtils.newFileUtils();
                    renamedFile = fileUtils.createTempFile("zip", ".tmp", fileUtils.getParentFile(this.zipFile));
                    try {
                        if (!this.zipFile.renameTo(renamedFile)) {
                            throw new BuildException("Unable to rename old file to temporary file");
                        }
                    }
                    catch (SecurityException e) {
                        throw new BuildException("Not allowed to rename old file to temporary file");
                    }
                }
                String action = this.doUpdate ? "Updating " : "Building ";
                this.log(action + this.archiveType + ": " + this.zipFile.getAbsolutePath());
                ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(this.zipFile));
                zOut.setEncoding(this.encoding);
                try {
                    if (this.doCompress) {
                        zOut.setMethod(8);
                    } else {
                        zOut.setMethod(0);
                    }
                    this.initZipOutputStream(zOut);
                    if (this.baseDir != null) {
                        this.addFiles(this.getDirectoryScanner(this.baseDir), zOut, "", "");
                    }
                    this.addFiles(this.filesets, zOut);
                    if (this.doUpdate) {
                        this.addingNewFiles = false;
                        ZipFileSet oldFiles = new ZipFileSet();
                        oldFiles.setSrc(renamedFile);
                        int i3 = 0;
                        while (i3 < this.addedFiles.size()) {
                            PatternSet.NameEntry ne = oldFiles.createExclude();
                            ne.setName((String)this.addedFiles.elementAt(i3));
                            ++i3;
                        }
                        Vector<ZipFileSet> tmp = new Vector<ZipFileSet>(1);
                        tmp.addElement(oldFiles);
                        this.addFiles(tmp, zOut);
                    }
                    this.finalizeZipOutputStream(zOut);
                    if (this.doUpdate && !renamedFile.delete()) {
                        this.log("Warning: unable to delete temporary file " + renamedFile.getName(), 1);
                    }
                    success = true;
                    Object var14_21 = null;
                }
                catch (Throwable throwable) {
                    block32: {
                        Object var14_22 = null;
                        try {
                            if (zOut != null) {
                                zOut.close();
                            }
                        }
                        catch (IOException ex) {
                            if (!success) break block32;
                            throw ex;
                        }
                    }
                    throw throwable;
                }
                try {
                    if (zOut != null) {
                        zOut.close();
                    }
                }
                catch (IOException ex) {
                    if (success) {
                        throw ex;
                    }
                }
            }
            catch (IOException ioe) {
                String msg = "Problem creating " + this.archiveType + ": " + ioe.getMessage();
                if (!(this.doUpdate && renamedFile == null || this.zipFile.delete())) {
                    msg = msg + " (and the archive is probably corrupt but I could not delete it)";
                }
                if (this.doUpdate && renamedFile != null && !renamedFile.renameTo(this.zipFile)) {
                    msg = msg + " (and I couldn't rename the temporary file " + renamedFile.getName() + " back)";
                }
                throw new BuildException(msg, ioe, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var17_14 = null;
            this.cleanUp();
            throw throwable;
        }
        Object var17_13 = null;
        this.cleanUp();
    }

    protected boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    protected void addFiles(FileScanner scanner, ZipOutputStream zOut, String prefix, String fullpath) throws IOException {
        if (prefix.length() > 0 && fullpath.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes must not be set on the same fileset.");
        }
        File thisBaseDir = scanner.getBasedir();
        String[] dirs = scanner.getIncludedDirectories();
        if (dirs.length > 0 && fullpath.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int i = 0;
        while (i < dirs.length) {
            if (!"".equals(dirs[i])) {
                String name = dirs[i].replace(File.separatorChar, '/');
                if (!name.endsWith("/")) {
                    name = name + "/";
                }
                this.addParentDirs(thisBaseDir, name, zOut, prefix);
            }
            ++i;
        }
        String[] files = scanner.getIncludedFiles();
        if (files.length > 1 && fullpath.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a singlefile.");
        }
        int i2 = 0;
        while (i2 < files.length) {
            File f = new File(thisBaseDir, files[i2]);
            if (fullpath.length() > 0) {
                this.addParentDirs(null, fullpath, zOut, "");
                this.zipFile(f, zOut, fullpath);
            } else {
                String name = files[i2].replace(File.separatorChar, '/');
                this.addParentDirs(thisBaseDir, name, zOut, prefix);
                this.zipFile(f, zOut, prefix + name);
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addZipEntries(ZipFileSet fs, DirectoryScanner ds, ZipOutputStream zOut, String prefix, String fullpath) throws IOException {
        this.log("adding zip entries: " + fullpath, 3);
        if (prefix.length() > 0 && fullpath.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes must not be set on the same fileset.");
        }
        ZipScanner zipScanner = (ZipScanner)ds;
        File zipSrc = fs.getSrc();
        ZipInputStream in = null;
        try {
            java.util.zip.ZipEntry origEntry;
            in = new ZipInputStream(new FileInputStream(zipSrc));
            while ((origEntry = in.getNextEntry()) != null) {
                void var9_10;
                ZipEntry entry = new ZipEntry((java.util.zip.ZipEntry)var9_10);
                String vPath = entry.getName();
                if (!zipScanner.match(vPath)) continue;
                if (fullpath.length() > 0) {
                    this.addParentDirs(null, fullpath, zOut, "");
                    this.zipFile(in, zOut, fullpath, entry.getTime(), zipSrc);
                    continue;
                }
                this.addParentDirs(null, vPath, zOut, prefix);
                if (entry.isDirectory()) continue;
                this.zipFile(in, zOut, prefix + vPath, entry.getTime(), zipSrc);
            }
            Object var13_12 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean createEmptyZip(File zipFile) {
        this.log("Note: creating empty " + this.archiveType + " archive " + zipFile, 2);
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(zipFile);
                byte[] empty = new byte[22];
                empty[0] = 80;
                empty[1] = 75;
                empty[2] = 5;
                empty[3] = 6;
                ((OutputStream)os).write(empty);
            }
            catch (IOException ioe) {
                throw new BuildException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe, this.location);
            }
            Object var5_5 = null;
            if (os == null) return true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (os == null) throw throwable;
            try {
                ((OutputStream)os).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ((OutputStream)os).close();
        return true;
    }

    protected boolean isUpToDate(FileScanner[] scanners, File zipFile) throws BuildException {
        String[][] fileNames = Zip.grabFileNames(scanners);
        File[] files = Zip.grabFiles(scanners, fileNames);
        if (files.length == 0) {
            if (this.emptyBehavior.equals("skip")) {
                this.log("Warning: skipping " + this.archiveType + " archive " + zipFile + " because no files were included.", 1);
                return true;
            }
            if (this.emptyBehavior.equals("fail")) {
                throw new BuildException("Cannot create " + this.archiveType + " archive " + zipFile + ": no files were included.", this.location);
            }
            return this.createEmptyZip(zipFile);
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].equals(zipFile)) {
                throw new BuildException("A zip file cannot include itself", this.location);
            }
            ++i;
        }
        if (!zipFile.exists()) {
            return false;
        }
        SourceFileScanner sfs = new SourceFileScanner(this);
        MergingMapper mm = new MergingMapper();
        mm.setTo(zipFile.getAbsolutePath());
        int i2 = 0;
        while (i2 < scanners.length) {
            if (sfs.restrict(fileNames[i2], scanners[i2].getBasedir(), null, mm).length > 0) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected static File[] grabFiles(FileScanner[] scanners) {
        return Zip.grabFiles(scanners, Zip.grabFileNames(scanners));
    }

    protected static File[] grabFiles(FileScanner[] scanners, String[][] fileNames) {
        Vector<File> files = new Vector<File>();
        int i = 0;
        while (i < fileNames.length) {
            File thisBaseDir = scanners[i].getBasedir();
            int j = 0;
            while (j < fileNames[i].length) {
                files.addElement(new File(thisBaseDir, fileNames[i][j]));
                ++j;
            }
            ++i;
        }
        Object[] toret = new File[files.size()];
        files.copyInto(toret);
        return toret;
    }

    protected static String[][] grabFileNames(FileScanner[] scanners) {
        String[][] result = new String[scanners.length][];
        int i = 0;
        while (i < scanners.length) {
            String[] files = scanners[i].getIncludedFiles();
            String[] dirs = scanners[i].getIncludedDirectories();
            result[i] = new String[files.length + dirs.length];
            System.arraycopy(files, 0, result[i], 0, files.length);
            System.arraycopy(dirs, 0, result[i], files.length, dirs.length);
            ++i;
        }
        return result;
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath) throws IOException {
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.log("adding directory " + vPath, 3);
        this.addedDirs.put(vPath, vPath);
        ZipEntry ze = new ZipEntry(vPath);
        if (dir != null && dir.exists()) {
            ze.setTime(dir.lastModified());
        } else {
            ze.setTime(System.currentTimeMillis());
        }
        ze.setSize(0L);
        ze.setMethod(0);
        ze.setCrc(EMPTY_CRC);
        ze.setExternalAttributes(1107099664L);
        zOut.putNextEntry(ze);
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified, File file) throws IOException {
        if (this.entries.contains(vPath)) {
            if (this.duplicate.equals("preserve")) {
                this.log(vPath + " already added, skipping", 2);
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new BuildException("Duplicate file " + vPath + " was found and the duplicate " + "attribute is 'fail'.");
            }
            this.log("duplicate file " + vPath + " found, adding.", 3);
        } else {
            this.log("adding entry " + vPath, 3);
        }
        this.entries.put(vPath, vPath);
        ZipEntry ze = new ZipEntry(vPath);
        ze.setTime(lastModified);
        if (!this.doCompress) {
            long size = 0L;
            CRC32 cal = new CRC32();
            if (!in.markSupported()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                    bos.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in = new ByteArrayInputStream(bos.toByteArray());
            } else {
                in.mark(Integer.MAX_VALUE);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in.reset();
            }
            ze.setSize(size);
            ze.setCrc(cal.getValue());
        }
        zOut.putNextEntry(ze);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            if (count == 0) continue;
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        this.addedFiles.addElement(vPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.location);
        }
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut, vPath, file.lastModified(), null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fIn.close();
            throw throwable;
        }
        fIn.close();
    }

    protected void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix) throws IOException {
        if (!this.doFilesonly) {
            String dir;
            Stack<String> directories = new Stack<String>();
            int slashPos = entry.length();
            while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
                dir = entry.substring(0, slashPos + 1);
                if (this.addedDirs.get(prefix + dir) != null) break;
                directories.push(dir);
            }
            while (!directories.isEmpty()) {
                dir = (String)directories.pop();
                File f = null;
                f = baseDir != null ? new File(baseDir, dir) : new File(dir);
                this.zipDir(f, zOut, prefix + dir);
            }
        }
    }

    protected void addFiles(Vector filesets, ZipOutputStream zOut) throws IOException {
        int i = 0;
        while (i < filesets.size()) {
            FileSet fs = (FileSet)filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String prefix = "";
            String fullpath = "";
            if (fs instanceof ZipFileSet) {
                ZipFileSet zfs = (ZipFileSet)fs;
                prefix = zfs.getPrefix();
                fullpath = zfs.getFullpath();
            }
            if (prefix.length() > 0 && !prefix.endsWith("/") && !prefix.endsWith("\\")) {
                prefix = prefix + "/";
            }
            if (prefix.length() > 0) {
                this.addParentDirs(null, prefix, zOut, "");
                this.zipDir(null, zOut, prefix);
            } else if (fullpath.length() > 0) {
                this.addParentDirs(null, fullpath, zOut, "");
            }
            if (fs instanceof ZipFileSet && ((ZipFileSet)fs).getSrc() != null) {
                this.addZipEntries((ZipFileSet)fs, ds, zOut, prefix, fullpath);
            } else {
                this.addFiles(ds, zOut, prefix, fullpath);
            }
            ++i;
        }
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        Enumeration enumeration = this.filesetsFromGroupfilesets.elements();
        while (enumeration.hasMoreElements()) {
            ZipFileSet zf = (ZipFileSet)enumeration.nextElement();
            this.filesets.removeElement(zf);
        }
        this.filesetsFromGroupfilesets.removeAllElements();
    }

    public void reset() {
        this.filesets.removeAllElements();
        this.zipFile = null;
        this.baseDir = null;
        this.groupfilesets.removeAllElements();
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.emptyBehavior = "skip";
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    public static class Duplicate
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "preserve", "fail"};
        }
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }
}

