/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.data.AbstractDataset;
import org.jfree.data.Range;
import org.jfree.data.ValueDataset;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;

public class SourceMeterDataset
extends AbstractDataset
implements ValueDataset,
DataSourceListener,
EndNotificationListener {
    static final long serialVersionUID = 42714295797937638L;
    protected transient DataSource source = null;
    protected transient boolean dirty = false;
    double min;
    double max;
    double value;

    public SourceMeterDataset(DataSource dataSource) {
        this.source = dataSource;
        this.min = -1.0;
        this.max = 1.0;
        this.value = 0.0;
    }

    public SourceMeterDataset() {
        this(null);
    }

    public DataSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(DataSource dataSource) {
        if (this.source != null) {
            this.source.removeListener((DataSourceListener)this);
            this.source.removeEndNotificationListener((EndNotificationListener)this);
        }
        this.source = dataSource;
        if (this.source == null) {
            return;
        }
        try {
            DataSource dataSource2 = this.source;
            synchronized (dataSource2) {
                try {
                    this.source.computeMin();
                    this.source.computeMax();
                    this.min = this.source.getDoubleMin();
                    this.max = this.source.getDoubleMax();
                    this.value = this.source.getDoubleValue(this.source.computeLastIndex());
                }
                catch (DataException dataException) {
                    try {
                        this.min = this.source.getDoubleMin();
                        this.max = this.source.getDoubleMax();
                        this.value = this.source.getDoubleValue(this.source.getLastIndex());
                    }
                    catch (DataException dataException2) {
                        this.min = -1.0;
                        this.max = 1.0;
                        this.value = 0.0;
                    }
                }
            }
            if (this.min > this.max) {
                double d = this.max;
                this.max = this.min;
                this.min = d;
            }
            if (this.min == this.max) {
                this.min = this.value - 1.0;
                this.max = this.value + 1.0;
            }
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        this.source.addListener((DataSourceListener)this);
        this.source.addEndNotificationListener((EndNotificationListener)this);
        this.fireDatasetChanged();
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        try {
            if (l2 == dataSource.getLastIndex()) {
                this.dirty = true;
            }
        }
        catch (UnsupportedOperation unsupportedOperation) {
            // empty catch block
        }
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        try {
            this.value = this.source.getDoubleValue(l2);
            this.dirty = true;
        }
        catch (UnsupportedOperation unsupportedOperation) {
            unsupportedOperation.printStackTrace();
        }
        catch (DataException dataException) {
            dataException.printStackTrace();
        }
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
        this.dirty = true;
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
        try {
            this.min = this.source.getDoubleMin();
            this.max = this.source.getDoubleMax();
            this.value = this.source.getDoubleValue(dataSource.getLastIndex());
        }
        catch (DataException dataException) {
            this.min = this.value;
            this.max = this.value;
        }
        if (this.min == this.max) {
            this.min = this.value - Math.abs(this.value * 0.01);
            this.max = this.value + Math.abs(this.value * 0.01);
            if (this.min == this.max) {
                this.min = this.value - 1.0;
            }
            this.max = this.value + 1.0;
        }
        this.dirty = true;
    }

    public void notificationEnd(Object object) {
        if (this.dirty) {
            this.fireDatasetChanged();
            this.dirty = false;
        }
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    public String getName() {
        if (this.source == null) {
            return "";
        }
        return DataInfo.getLabel((Object)this.source);
    }

    public String getUnit() {
        if (this.source == null) {
            return "";
        }
        return DataInfo.getUnit((Object)this.source);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.source);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.source = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.source != null) {
            this.source.addListener((DataSourceListener)this);
            this.source.addEndNotificationListener((EndNotificationListener)this);
        }
    }

    public Number getValue() {
        if (Double.isNaN(this.value)) {
            return null;
        }
        if (Double.isInfinite(this.value)) {
            return null;
        }
        return new Double(this.value);
    }

    public double getDoubleValue() {
        return this.value;
    }

    public Range getRange() {
        return new Range(this.min, this.max);
    }

    public Object clone() throws CloneNotSupportedException {
        SourceMeterDataset sourceMeterDataset = (SourceMeterDataset)((Object)super.clone());
        if (this.source != null) {
            this.source.addListener((DataSourceListener)sourceMeterDataset);
            this.source.addEndNotificationListener((EndNotificationListener)sourceMeterDataset);
        }
        return sourceMeterDataset;
    }

    public SourceMeterDataset cloneSet() {
        try {
            return (SourceMeterDataset)((Object)this.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

