/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.ui.PropertiesPanel1D;
import simtools.diagram.DiagramSelectedLineShape;
import simtools.diagram.DiagramSelectedShape;
import simtools.diagram.LineShapeInterface;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.ui.JPropertiesPanel;

public class ConnectionShape
extends Abstract1DShape
implements Resizable,
LineShapeInterface,
Serializable {
    static final long serialVersionUID = -961863327687064518L;
    protected double[] _xv = new double[2];
    protected double[] _yv = new double[2];

    public ConnectionShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this._xv[0] = n;
        this._xv[1] = n + n3;
        this._yv[0] = n;
        this._yv[1] = n2 + n4;
        this.setBounds();
    }

    protected AbstractShape cloneShape() {
        ConnectionShape connectionShape = (ConnectionShape)super.cloneShape();
        connectionShape._xv = new double[this._xv.length];
        connectionShape._yv = new double[this._yv.length];
        for (int i = 0; i < this._xv.length; ++i) {
            connectionShape._xv[i] = this._xv[i];
            connectionShape._yv[i] = this._yv[i];
        }
        return connectionShape;
    }

    public JPropertiesPanel createPanel() {
        return new PropertiesPanel1D(false, false);
    }

    public void translate(int n, int n2) {
        int n3 = 0;
        while (n3 < this._xv.length) {
            int n4 = n3;
            this._xv[n4] = this._xv[n4] + (double)n;
            int n5 = n3++;
            this._yv[n5] = this._yv[n5] + (double)n2;
        }
        this.setBounds();
    }

    public void resize(int n, int n2) {
        double d = ((double)this._w + (double)n) / (double)this._w;
        double d2 = ((double)this._h + (double)n2) / (double)this._h;
        if (d * (double)this._w < 1.0) {
            return;
        }
        if (d2 * (double)this._h < 1.0) {
            return;
        }
        for (int i = 0; i < this._xv.length; ++i) {
            this._xv[i] = (this._xv[i] - (double)this._ox) * d + (double)this._ox;
            this._yv[i] = (this._yv[i] - (double)this._oy - (double)this._y) * d2 + (double)this._oy + (double)this._y;
        }
        this.setBounds();
    }

    protected void setBounds() {
        int n;
        this._ox = (int)this._xv[0];
        this._oy = (int)this._yv[0];
        for (n = 1; n < this._xv.length; ++n) {
            if (this._ox > (int)this._xv[n]) {
                this._ox = (int)this._xv[n];
            }
            if (!((double)this._oy > this._yv[n])) continue;
            this._oy = (int)this._yv[n];
        }
        this._w = 0;
        this._h = 0;
        for (n = 0; n < this._xv.length; ++n) {
            if ((double)(this._w + this._ox) < this._xv[n]) {
                this._w = (int)this._xv[n] - this._ox;
            }
            if (!((double)(this._h + this._oy) < this._yv[n])) continue;
            this._h = (int)this._yv[n] - this._oy;
        }
        if (this._w == 0) {
            this._w = 1;
        }
        if (this._h == 0) {
            this._h = 1;
        }
        this._y = this._h;
    }

    public int intersects(int n, int n2, int n3, int n4) {
        if (n3 < this._ox || n4 < this._oy || n > this._ox + this._w || n2 > this._oy + this._h) {
            return -1;
        }
        return 0;
    }

    public boolean contains(double d, double d2) {
        return this.createSelectedShape((int)d, (int)d2) != null;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        int n = (int)d;
        int n2 = (int)d2;
        int n3 = (int)(d + d3);
        int n4 = (int)(d2 + d4);
        return this.intersects(n, n2, n3, n4) > 0;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new LinkPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new LinkPathIterator(affineTransform);
    }

    public int pointsNumber() {
        return this._xv.length;
    }

    public int getX(int n) {
        return (int)this._xv[n];
    }

    public int getY(int n) {
        return (int)this._yv[n];
    }

    public void translatePoint(int n, int n2, int n3) {
        int n4 = n;
        this._xv[n4] = this._xv[n4] + (double)n2;
        int n5 = n;
        this._yv[n5] = this._yv[n5] + (double)n3;
        this.setBounds();
    }

    protected Shape getDelegateShape() {
        return this;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setBounds();
    }

    public DiagramSelectedShape createSelectedShape(int n, int n2) {
        SelectedConnectionShape selectedConnectionShape = new SelectedConnectionShape(null);
        Point point = selectedConnectionShape.selectPointAt(n, n2, true);
        if (point != null) {
            selectedConnectionShape.setOrigin(point);
            return selectedConnectionShape;
        }
        return null;
    }

    public DiagramSelectedShape createSelectedShape(Rectangle2D rectangle2D) {
        SelectedConnectionShape selectedConnectionShape = new SelectedConnectionShape(null);
        Point point = selectedConnectionShape.selectPointsInside(rectangle2D);
        if (point != null) {
            selectedConnectionShape.setOrigin(point);
            return selectedConnectionShape;
        }
        return null;
    }

    public DiagramSelectedShape createSelectedShape(Point point) {
        return new SelectedConnectionShape(point);
    }

    public class SelectedConnectionShape
    extends DiagramSelectedLineShape {
        boolean[] _selected;

        protected SelectedConnectionShape(Point point) {
            super(ConnectionShape.this, point);
            this._selected = new boolean[ConnectionShape.this._xv.length];
            for (int i = 0; i < this._selected.length; ++i) {
                this._selected[i] = false;
            }
        }

        public void selectPoint(int n, boolean bl) {
            this._selected[n] = bl;
        }

        public boolean isSelectedPoint(int n) {
            return this._selected[n];
        }
    }

    public class LinkPathIterator
    implements PathIterator {
        private int _index = 0;
        private AffineTransform _aff;

        public LinkPathIterator(AffineTransform affineTransform) {
            this._aff = affineTransform;
        }

        public int currentSegment(double[] dArray) {
            if (this._index >= ConnectionShape.this._xv.length) {
                throw new NoSuchElementException("LinkPathIterator is out of bounds");
            }
            dArray[0] = ConnectionShape.this._xv[this._index];
            dArray[1] = ConnectionShape.this._yv[this._index];
            if (this._aff != null) {
                this._aff.transform(dArray, 0, dArray, 0, 1);
            }
            if (this._index == 0) {
                return 0;
            }
            return 1;
        }

        public int currentSegment(float[] fArray) {
            if (this._index >= ConnectionShape.this._xv.length) {
                throw new NoSuchElementException("LinkPathIterator is out of bounds");
            }
            fArray[0] = (float)ConnectionShape.this._xv[this._index];
            fArray[1] = (float)ConnectionShape.this._yv[this._index];
            if (this._aff != null) {
                this._aff.transform(fArray, 0, fArray, 0, 1);
            }
            if (this._index == 0) {
                return 0;
            }
            return 1;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this._index >= ConnectionShape.this._xv.length;
        }

        public void next() {
            ++this._index;
        }
    }
}

