/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsynoptic.builtin.ui.PropertiesPanel1D;
import jsynoptic.ui.SourceTree;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.ui.ActionCheckBox;
import simtools.ui.BasicMessageWriter;
import simtools.ui.ImageMapper;
import simtools.ui.ImagePreview;
import simtools.ui.ResourceFinder;

public class ImagePropertiesPanel
extends PropertiesPanel1D {
    protected JLabel cmLabel;
    protected JList cmlist;
    protected JButton cmNew;
    protected JButton cmDelete;
    protected JLabel dsLabel;
    protected SourceTree dstree;
    protected ActionCheckBox cbDynamic;
    protected JLabel lstatic;
    protected JButton bChoose;
    protected JFileChooser fileChooser;
    protected JRadioButton rbFit;
    protected JRadioButton rbResize;
    protected File currentFile;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$ImageShape == null ? (class$jsynoptic$builtin$ImageShape = ImagePropertiesPanel.class$("jsynoptic.builtin.ImageShape")) : class$jsynoptic$builtin$ImageShape);
    public static BasicMessageWriter messageWriter = ResourceFinder.getMessages(class$jsynoptic$builtin$ImageShape == null ? (class$jsynoptic$builtin$ImageShape = ImagePropertiesPanel.class$("jsynoptic.builtin.ImageShape")) : class$jsynoptic$builtin$ImageShape);
    protected ImageMapper mapper;
    protected DataSource source;
    static /* synthetic */ Class class$jsynoptic$builtin$ImageShape;

    public ImagePropertiesPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createContent(), "Center");
    }

    public JComponent createContent() {
        Box box = Box.createVerticalBox();
        box.add(super.createContent(true, true));
        Box box2 = Box.createHorizontalBox();
        this.rbFit = new JRadioButton(resources.getString("ScaleImageToFitObjectSize"), false);
        box2.add(this.rbFit);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        this.rbResize = new JRadioButton(resources.getString("ChangeObjectSizeToFitImage"), false);
        box2.add(this.rbResize);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbFit);
        buttonGroup.add(this.rbResize);
        this.currentFile = null;
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel(resources.getString("Image:")));
        this.lstatic = new JLabel();
        box2.add(this.lstatic);
        if (this.currentFile != null) {
            this.lstatic.setText(this.currentFile.getName());
        }
        box2.add(Box.createHorizontalGlue());
        this.bChoose = new JButton(resources.getString("Choose"));
        box2.add(this.bChoose);
        box.add(box2);
        this.bChoose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ImagePropertiesPanel.this.fileChooser == null) {
                    ImagePropertiesPanel.this.fileChooser = new JFileChooser();
                    ImagePropertiesPanel.this.fileChooser.setAccessory(new ImagePreview(ImagePropertiesPanel.this.fileChooser));
                }
                ImagePropertiesPanel.this.fileChooser.setSelectedFile(ImagePropertiesPanel.this.currentFile);
                int n = ImagePropertiesPanel.this.fileChooser.showDialog(null, resources.getString("SelectImage"));
                if (n == 0) {
                    ImagePropertiesPanel.this.currentFile = ImagePropertiesPanel.this.fileChooser.getSelectedFile();
                    if (ImagePropertiesPanel.this.currentFile != null) {
                        try {
                            ImagePropertiesPanel.this.lstatic.setText(ImagePropertiesPanel.this.currentFile.getName());
                            BufferedImage bufferedImage = ImageIO.read(ImagePropertiesPanel.this.currentFile);
                            if (ImagePropertiesPanel.this.rbResize.isSelected()) {
                                ImagePropertiesPanel.this.nfWidth.setValue(bufferedImage.getWidth());
                                ImagePropertiesPanel.this.nfHeight.setValue(bufferedImage.getHeight());
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.rbResize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ImagePropertiesPanel.this.rbResize.isSelected() && ImagePropertiesPanel.this.currentFile != null) {
                    try {
                        BufferedImage bufferedImage = ImageIO.read(ImagePropertiesPanel.this.currentFile);
                        ImagePropertiesPanel.this.nfWidth.setValue(bufferedImage.getWidth());
                        ImagePropertiesPanel.this.nfHeight.setValue(bufferedImage.getHeight());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        box2 = Box.createHorizontalBox();
        this.cbDynamic = new ActionCheckBox(resources.getString("UseDynamicImages")){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagePropertiesPanel.this.cmLabel.setEnabled(this.isSelected());
                ImagePropertiesPanel.this.dsLabel.setEnabled(this.isSelected());
                ImagePropertiesPanel.this.cmlist.setEnabled(this.isSelected());
                ImagePropertiesPanel.this.cmNew.setEnabled(this.isSelected());
                ImagePropertiesPanel.this.cmDelete.setEnabled(this.isSelected() && ImagePropertiesPanel.this.cmlist.getSelectedValue() != null);
                ImagePropertiesPanel.this.dstree.setEnabled(this.isSelected());
            }
        };
        box2.add(this.cbDynamic);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        Box box3 = Box.createVerticalBox();
        this.cmLabel = new JLabel(resources.getString("ChooseAnImageMapper"));
        this.cmLabel.setAlignmentX(0.0f);
        Box box4 = Box.createHorizontalBox();
        box4.add(this.cmLabel);
        box4.add(Box.createHorizontalGlue());
        box3.add(box4);
        final ImageMapperListModel imageMapperListModel = new ImageMapperListModel();
        this.cmlist = new JList(imageMapperListModel);
        this.cmlist.setSelectionMode(0);
        this.cmlist.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.cmlist);
        box3.add(jScrollPane);
        Box box5 = Box.createHorizontalBox();
        this.cmNew = new JButton(resources.getString("New"));
        box5.add(this.cmNew);
        this.cmDelete = new JButton(resources.getString("Delete"));
        box5.add(this.cmDelete);
        box5.add(Box.createHorizontalGlue());
        box3.add(box5);
        box2.add(box3);
        Box box6 = Box.createVerticalBox();
        this.dsLabel = new JLabel(resources.getString("ChooseADataSource"));
        this.dsLabel.setAlignmentX(0.0f);
        Box box7 = Box.createHorizontalBox();
        box7.add(this.dsLabel);
        box7.add(Box.createHorizontalGlue());
        box6.add(box7);
        this.dstree = new SourceTree(DataSourcePool.global);
        this.dstree.setVisibleRowCount(5);
        JScrollPane jScrollPane2 = new JScrollPane(this.dstree);
        box6.add(jScrollPane2);
        box2.add(box6);
        box.add(box2);
        this.cmNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageMapper imageMapper = ImageMapper.createImageMapperDialog(null);
                if (imageMapper == null) {
                    return;
                }
                if (ImageMapper.imageMappers == null) {
                    ImageMapper.imageMappers = new Vector();
                }
                if (ImageMapper.imageMappers.contains(imageMapper)) {
                    String[] stringArray = new String[]{messageWriter.print1args("ReplaceExistingImageMapperNamed?", imageMapper.toString())};
                    int n = JOptionPane.showConfirmDialog(ImagePropertiesPanel.this, stringArray, messageWriter.print0args("MapperAlreadyExists!"), 0);
                    if (n == 0) {
                        int n2 = ImageMapper.imageMappers.indexOf(imageMapper);
                        ImageMapper.imageMappers.set(n2, imageMapper);
                        imageMapperListModel.update();
                        ImagePropertiesPanel.this.cmlist.setSelectedValue(imageMapper, true);
                    }
                    return;
                }
                ImageMapper.imageMappers.add(imageMapper);
                imageMapperListModel.update();
                ImagePropertiesPanel.this.cmlist.setSelectedValue(imageMapper, true);
            }
        });
        this.cmDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = ImagePropertiesPanel.this.cmlist.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (ImageMapper.imageMappers != null) {
                    ImageMapper.imageMappers.remove(e);
                }
                imageMapperListModel.update();
            }
        });
        this.cmDelete.setEnabled(false);
        this.cmlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ImagePropertiesPanel.this.cmDelete.setEnabled(ImagePropertiesPanel.this.cmlist.getSelectedValue() != null);
            }
        });
        this.cmlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = ImagePropertiesPanel.this.cmlist.locationToIndex(mouseEvent.getPoint());
                    ((ImageMapper)ImageMapper.imageMappers.get(n)).editDialog(null);
                }
            }
        });
        return box;
    }

    protected String lineColorChooserTitle() {
        return resources.getString("ChooseTheFrameColor");
    }

    protected String lineColorLabel() {
        return resources.getString("DisplayFrame");
    }

    public String[] getPropertyNames() {
        String[] stringArray = super.getPropertyNames();
        String[] stringArray2 = new String[stringArray.length + 4];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[i++] = "IMAGE_FIT_TO_OBJECT";
        stringArray2[i++] = "IMAGE_FILE";
        stringArray2[i++] = "IMAGE_MAPPER";
        stringArray2[i++] = "IMAGE_MAPPER_SOURCE";
        return stringArray2;
    }

    public Object getPropertyValue(String string) {
        Object object;
        Object object2 = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("IMAGE_FIT_TO_OBJECT")) {
            object2 = new Boolean(this.rbFit.isSelected());
        } else if (string.equalsIgnoreCase("IMAGE_FILE")) {
            object2 = this.currentFile;
        } else if (string.equalsIgnoreCase("IMAGE_MAPPER")) {
            object2 = this.cmlist.getSelectedValue();
        } else if (string.equalsIgnoreCase("IMAGE_MAPPER_SOURCE") && this.cbDynamic.isSelected() && (object = this.dstree.getSelectedSourceOrCollection()) instanceof DataSource) {
            object2 = (DataSource)object;
        }
        return object2;
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase("IMAGE_FIT_TO_OBJECT")) {
            if (object instanceof Boolean) {
                this.rbFit.setSelected((Boolean)object);
                this.rbResize.setSelected(!this.rbFit.isSelected());
            }
        } else if (string.equalsIgnoreCase("IMAGE_FILE")) {
            if (object instanceof File) {
                this.currentFile = (File)object;
            }
        } else if (string.equalsIgnoreCase("IMAGE_MAPPER")) {
            if (object instanceof ImageMapper) {
                this.mapper = (ImageMapper)object;
                this.cmlist.setSelectedValue(this.mapper, true);
                this.cbDynamic.setSelected(true);
            } else {
                this.cbDynamic.setSelected(false);
            }
            this.cbDynamic.apply();
        } else if (string.equalsIgnoreCase("IMAGE_MAPPER_SOURCE") && object instanceof DataSource) {
            this.source = (DataSource)object;
            this.dstree.setSelectedValue(this.source);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ImageMapperListModel
    extends DefaultListModel {
        ImageMapperListModel() {
            this.fillFromMainList();
        }

        public void update() {
            this.clear();
            this.fillFromMainList();
        }

        protected void fillFromMainList() {
            if (ImageMapper.imageMappers != null) {
                Iterator iterator = ImageMapper.imageMappers.iterator();
                while (iterator.hasNext()) {
                    this.addElement(iterator.next());
                }
            }
        }
    }
}

