/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import jsynoptic.builtin.ui.PropertiesPanel2D;
import jsynoptic.ui.SourceTree;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.diagram.DiagramParameters;
import simtools.ui.ActionCheckBox;
import simtools.ui.ColorMapper;
import simtools.ui.CustomizedLocale;
import simtools.ui.DynamicColorChooser;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;
import simtools.ui.TextMapper;

public class TextPropertiesPanel
extends PropertiesPanel2D {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$TextShape == null ? (class$jsynoptic$builtin$TextShape = TextPropertiesPanel.class$("jsynoptic.builtin.TextShape")) : class$jsynoptic$builtin$TextShape);
    protected JButton btextcolor;
    protected JButton bbackcolor;
    protected JButton bframecolor;
    protected JButton beditmapper;
    protected JButton bnewmapper;
    protected JButton bdelmapper;
    protected Color noColor;
    protected ActionCheckBox cbResize;
    protected ActionCheckBox cbDataSource;
    protected JCheckBox cbBack;
    protected JCheckBox cbFrame;
    protected JLabel lwidth;
    protected JLabel lheight;
    protected JLabel lmapper;
    protected NumberField nfWidth;
    protected NumberField nfHeight;
    protected NumberField nfformat;
    protected JTextField tfText;
    protected JTextField tfpattern;
    protected SourceTree dstree;
    protected JLabel lformat;
    protected JLabel lpattern;
    protected JComboBox cbxformat;
    protected JComboBox cbxmapper;
    protected JLabel lformatdigits;
    protected JPanel cards;
    protected Color textColor;
    protected ColorMapper textMapper;
    protected transient DataSource textMapperSource;
    protected transient DataSource source;
    protected transient TextMapper mapper;
    protected transient NumberFormat decimalFormatter;
    protected transient NumberFormat scientificFormatter;
    static /* synthetic */ Class class$jsynoptic$builtin$TextShape;

    public TextPropertiesPanel() {
        this(true);
    }

    public TextPropertiesPanel(boolean bl) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createContent(bl), "Center");
    }

    public JComponent createContent(boolean bl) {
        this.textColor = DiagramParameters.DEFAULT_COLOR;
        this.textMapper = null;
        this.textMapperSource = null;
        this.source = null;
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        this.tfText = new JTextField("");
        box2.add(this.tfText);
        this.btextcolor = new JButton("    ");
        box2.add(this.btextcolor);
        this.noColor = this.btextcolor.getBackground();
        this.btextcolor.setFocusPainted(false);
        this.btextcolor.setBackground(this.textColor);
        box.add(box2);
        box.add(super.createContent(bl, true));
        this.dstree = new SourceTree(DataSourcePool.global);
        this.dstree.setVisibleRowCount(5);
        box2 = Box.createHorizontalBox();
        this.cbDataSource = new ActionCheckBox(resources.getString("UseADataSource"), this.source != null){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPropertiesPanel.this.dstree.setEnabled(this.isSelected());
                TextPropertiesPanel.this.cbxformat.setEnabled(this.isSelected());
                TextPropertiesPanel.this.lformat.setEnabled(this.isSelected());
                TextPropertiesPanel.this.cbxformat.setEnabled(this.isSelected());
                TextPropertiesPanel.this.lpattern.setEnabled(this.isSelected());
                TextPropertiesPanel.this.tfpattern.setEnabled(this.isSelected());
                TextPropertiesPanel.this.tfText.setEnabled(!this.isSelected());
                if (this.isSelected()) {
                    String string;
                    TextPropertiesPanel.this.dstree.setSelectedValue(TextPropertiesPanel.this.source);
                    ActionListener[] actionListenerArray = TextPropertiesPanel.this.cbxformat.getActionListeners();
                    if (actionListenerArray != null) {
                        for (int i = 0; i < actionListenerArray.length; ++i) {
                            actionListenerArray[i].actionPerformed(new ActionEvent(TextPropertiesPanel.this.cbxformat, 0, ""));
                        }
                    }
                    if ((string = DataInfo.getLabel(TextPropertiesPanel.this.source)) == null || string.equals("")) {
                        string = TextPropertiesPanel.this.tfText.getText();
                    }
                    TextPropertiesPanel.this.setName(string);
                } else {
                    TextPropertiesPanel.this.source = null;
                    TextPropertiesPanel.this.lformatdigits.setEnabled(false);
                    TextPropertiesPanel.this.nfformat.setEnabled(false);
                    TextPropertiesPanel.this.setName(TextPropertiesPanel.this.tfText.getText());
                }
            }
        };
        box2.add(this.cbDataSource);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        JScrollPane jScrollPane = new JScrollPane(this.dstree);
        box.add(jScrollPane);
        box2 = Box.createHorizontalBox();
        this.lformat = new JLabel(resources.getString("ValueFormat"));
        box2.add(this.lformat);
        box2.add(Box.createHorizontalGlue());
        this.cbxformat = new JComboBox();
        box2.add(this.cbxformat);
        this.cbxformat.addItem(resources.getString("String"));
        this.cbxformat.addItem(resources.getString("Decimal"));
        this.cbxformat.addItem(resources.getString("Scientific"));
        this.cbxformat.addItem(resources.getString("Hexadecimal"));
        this.cbxformat.addItem(resources.getString("Octal"));
        this.cbxformat.addItem(resources.getString("Binary"));
        this.cbxformat.addItem(resources.getString("UseMapper"));
        this.cbxformat.addItem(resources.getString("Date"));
        this.cbxformat.addItem(resources.getString("Time"));
        this.cbxformat.addItem(resources.getString("DateTime"));
        this.cbxformat.setEditable(false);
        box.add(box2);
        this.cards = new JPanel();
        this.cards.setLayout(new CardLayout());
        box2 = Box.createHorizontalBox();
        this.lformatdigits = new JLabel(resources.getString("DecimalDigits:"));
        box2.add(this.lformatdigits);
        box2.add(Box.createHorizontalGlue());
        this.decimalFormatter = NumberFormat.getNumberInstance(CustomizedLocale.get());
        this.scientificFormatter = NumberFormat.getNumberInstance(CustomizedLocale.get());
        if (this.scientificFormatter instanceof DecimalFormat) {
            ((DecimalFormat)this.scientificFormatter).applyPattern("0.000E0");
        }
        this.nfformat = new NumberField(0L, 3);
        box2.add(this.nfformat);
        this.nfformat.setColumns(3);
        this.nfformat.setHorizontalAlignment(4);
        this.cards.add((Component)box2, "bounds");
        box2 = Box.createHorizontalBox();
        this.cbxmapper = new JComboBox();
        box2.add(this.cbxmapper);
        this.cbxmapper.addItem(resources.getString("=======NONE======="));
        int n = 0;
        if (TextMapper.textMappers != null) {
            for (int i = 0; i < TextMapper.textMappers.size(); ++i) {
                TextMapper textMapper = (TextMapper)TextMapper.textMappers.get(i);
                if (textMapper.equals(this.mapper)) {
                    n = i + 1;
                }
                this.cbxmapper.addItem(textMapper);
            }
        }
        this.cbxmapper.setEditable(false);
        this.cbxmapper.setSelectedIndex(n);
        box2.add(this.cbxmapper);
        box2.add(Box.createHorizontalGlue());
        this.beditmapper = new JButton(resources.getString("Edit"));
        box2.add(this.beditmapper);
        this.bnewmapper = new JButton(resources.getString("New"));
        box2.add(this.bnewmapper);
        this.bdelmapper = new JButton(resources.getString("Delete"));
        box2.add(this.bdelmapper);
        if (n == 0) {
            this.beditmapper.setEnabled(false);
            this.bdelmapper.setEnabled(false);
        }
        this.cbxmapper.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = object.toString();
                if (string.length() > 18) {
                    string = string.substring(0, 15) + "...";
                }
                return new JLabel(string);
            }
        });
        this.beditmapper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextPropertiesPanel.this.mapper == null) {
                    return;
                }
                TextPropertiesPanel.this.mapper.editDialog(null);
                TextPropertiesPanel.this.cbxmapper.repaint();
            }
        });
        this.bnewmapper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPropertiesPanel.this.mapper = TextMapper.createTextMapperDialog(null);
                if (TextMapper.textMappers == null) {
                    TextMapper.textMappers = new Vector();
                }
                TextMapper.textMappers.add(TextPropertiesPanel.this.mapper);
                TextPropertiesPanel.this.cbxmapper.addItem(TextPropertiesPanel.this.mapper);
                TextPropertiesPanel.this.cbxmapper.setSelectedItem(TextPropertiesPanel.this.mapper);
                TextPropertiesPanel.this.cards.revalidate();
            }
        });
        this.bdelmapper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextPropertiesPanel.this.mapper == null) {
                    return;
                }
                if (TextMapper.textMappers != null) {
                    TextMapper.textMappers.remove(TextPropertiesPanel.this.mapper);
                }
                TextPropertiesPanel.this.cbxmapper.removeItem(TextPropertiesPanel.this.mapper);
                TextPropertiesPanel.this.cbxmapper.setSelectedIndex(0);
                TextPropertiesPanel.this.mapper = null;
                TextPropertiesPanel.this.bdelmapper.setEnabled(false);
                TextPropertiesPanel.this.beditmapper.setEnabled(false);
            }
        });
        this.cbxmapper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TextPropertiesPanel.this.cbxmapper.getSelectedIndex();
                if (n == 0) {
                    TextPropertiesPanel.this.beditmapper.setEnabled(false);
                    TextPropertiesPanel.this.bdelmapper.setEnabled(false);
                    TextPropertiesPanel.this.mapper = null;
                } else {
                    TextPropertiesPanel.this.mapper = (TextMapper)TextPropertiesPanel.this.cbxmapper.getItemAt(n);
                    TextPropertiesPanel.this.beditmapper.setEnabled(true);
                    TextPropertiesPanel.this.bdelmapper.setEnabled(true);
                }
            }
        });
        this.cards.add((Component)box2, "mapper");
        box.add(this.cards);
        CardLayout cardLayout = (CardLayout)this.cards.getLayout();
        if (this.cbxformat.getSelectedIndex() == 6) {
            cardLayout.show(this.cards, "mapper");
        } else {
            cardLayout.show(this.cards, "bounds");
        }
        box2 = Box.createHorizontalBox();
        this.lpattern = new JLabel(resources.getString("DisplayPattern:"));
        box2.add(this.lpattern);
        box2.add(Box.createHorizontalGlue());
        this.tfpattern = new JTextField("");
        box2.add(this.tfpattern);
        this.tfpattern.setHorizontalAlignment(4);
        box.add(box2);
        this.tfText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateName();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateName();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateName();
            }

            private void updateName() {
                TextPropertiesPanel.this.setName(TextPropertiesPanel.this.tfText.getText());
            }
        });
        this.setName(this.tfText.getText());
        this.cbxformat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                long l = -1L;
                if (TextPropertiesPanel.this.cbxformat.getSelectedIndex() == 1) {
                    l = TextPropertiesPanel.this.decimalFormatter.getMaximumFractionDigits();
                } else if (TextPropertiesPanel.this.cbxformat.getSelectedIndex() == 2 && TextPropertiesPanel.this.scientificFormatter instanceof DecimalFormat) {
                    object = ((DecimalFormat)TextPropertiesPanel.this.scientificFormatter).toPattern();
                    l = 0L;
                    l = ((String)object).indexOf(69) - ((String)object).indexOf(46);
                    if (l > 0L) {
                        --l;
                    }
                }
                if (l != -1L) {
                    TextPropertiesPanel.this.nfformat.setEnabled(true);
                    TextPropertiesPanel.this.nfformat.setValue(l);
                    TextPropertiesPanel.this.lformatdigits.setEnabled(true);
                } else {
                    TextPropertiesPanel.this.nfformat.setEnabled(false);
                    TextPropertiesPanel.this.nfformat.setValue(0L);
                    TextPropertiesPanel.this.lformatdigits.setEnabled(false);
                }
                object = (CardLayout)TextPropertiesPanel.this.cards.getLayout();
                if (TextPropertiesPanel.this.cbxformat.getSelectedIndex() == 6) {
                    ((CardLayout)object).show(TextPropertiesPanel.this.cards, "mapper");
                } else {
                    ((CardLayout)object).show(TextPropertiesPanel.this.cards, "bounds");
                }
            }
        });
        this.btextcolor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSource dataSource = TextPropertiesPanel.this.textMapperSource == null ? TextPropertiesPanel.this.source : TextPropertiesPanel.this.textMapperSource;
                Color color = DynamicColorChooser.showDialog(null, resources.getString("ChooseATextColor"), null, TextPropertiesPanel.this.textColor, dataSource, TextPropertiesPanel.this.textMapper);
                if (color == null) {
                    return;
                }
                TextPropertiesPanel.this.textColor = color;
                TextPropertiesPanel.this.textMapperSource = DynamicColorChooser.getSource();
                TextPropertiesPanel.this.textMapper = DynamicColorChooser.getMapper();
                TextPropertiesPanel.this.btextcolor.setBackground(TextPropertiesPanel.this.textColor);
            }
        });
        this.dstree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!treeSelectionEvent.isAddedPath()) {
                    return;
                }
                Object object = TextPropertiesPanel.this.dstree.getSelectedSourceOrCollection();
                TextPropertiesPanel.this.source = object instanceof DataSource ? (DataSource)object : null;
                String string = DataInfo.getLabel(TextPropertiesPanel.this.source);
                if (string == null || string.equals("")) {
                    string = TextPropertiesPanel.this.tfText.getText();
                }
                TextPropertiesPanel.this.setName(string);
            }
        });
        this.dstree.setSelectedValue(this.source);
        this.cbDataSource.apply();
        return box;
    }

    public void setName(String string) {
        String string2 = this.getName();
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        super.setName(string);
        if (!string2.equals(string)) {
            this.changes.firePropertyChange("name", string2, string);
        }
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            return super.toString();
        }
        return string;
    }

    protected String fillColorChooserTitle() {
        return resources.getString("ChooseBackgroundColor");
    }

    protected String fillColorLabel() {
        return resources.getString("UseBackgroundColor");
    }

    protected String lineColorChooserTitle() {
        return resources.getString("ChooseFrameColor");
    }

    protected String lineColorLabel() {
        return resources.getString("DisplayFrame");
    }

    public String[] getPropertyNames() {
        String[] stringArray = super.getPropertyNames();
        String[] stringArray2 = new String[stringArray.length + 9];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[i++] = "TEXT";
        stringArray2[i++] = "TEXT_COLOR";
        stringArray2[i++] = "TEXT_SOURCE";
        stringArray2[i++] = "FORMAT_MAPPER";
        stringArray2[i++] = "VALUE_FORMAT";
        stringArray2[i++] = "DECIMAL_DIGITS";
        stringArray2[i++] = "TEXT_MAPPER";
        stringArray2[i++] = "TEXT_MAPPER_SOURCE";
        stringArray2[i++] = "DISPLAY_PATTERN";
        return stringArray2;
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("TEXT")) {
            object = this.tfText.getText();
        } else if (string.equalsIgnoreCase("TEXT_COLOR")) {
            object = this.textColor;
        } else if (string.equalsIgnoreCase("TEXT_SOURCE")) {
            object = this.cbDataSource.isSelected() ? this.source : null;
        } else if (string.equalsIgnoreCase("VALUE_FORMAT")) {
            object = new Integer(this.cbxformat.getSelectedIndex());
        } else if (string.equalsIgnoreCase("FORMAT_MAPPER")) {
            object = this.mapper;
        } else if (string.equalsIgnoreCase("DECIMAL_DIGITS")) {
            object = new Integer((int)this.nfformat.getLongValue());
        } else if (string.equalsIgnoreCase("TEXT_MAPPER")) {
            object = this.textMapper;
        } else if (string.equalsIgnoreCase("TEXT_MAPPER_SOURCE")) {
            object = this.textMapperSource;
        } else if (string.equalsIgnoreCase("DISPLAY_PATTERN")) {
            object = this.tfpattern.getText();
        }
        return object;
    }

    public void setPropertyValue(String string, Object object) {
        if (string.equalsIgnoreCase("TEXT")) {
            if (object instanceof String) {
                this.tfText.setText((String)object);
            }
        } else if (string.equalsIgnoreCase("TEXT_COLOR")) {
            if (object instanceof Color) {
                this.textColor = (Color)object;
                this.btextcolor.setBackground(this.textColor);
            }
        } else if (string.equalsIgnoreCase("VALUE_FORMAT")) {
            if (object instanceof Integer) {
                this.cbxformat.setSelectedIndex((Integer)object);
            }
        } else if (string.equalsIgnoreCase("FORMAT_MAPPER")) {
            if (object instanceof TextMapper) {
                this.mapper = (TextMapper)object;
                for (int i = 0; i < this.cbxmapper.getItemCount(); ++i) {
                    if (!this.cbxmapper.getItemAt(i).equals(this.mapper)) continue;
                    this.cbxmapper.setSelectedIndex(i);
                    break;
                }
            }
        } else if (string.equalsIgnoreCase("TEXT_SOURCE")) {
            this.source = object instanceof DataSource ? (DataSource)object : null;
            this.cbDataSource.setSelected(this.source != null);
            this.cbDataSource.apply();
        } else if (string.equalsIgnoreCase("DECIMAL_DIGITS")) {
            if (object instanceof Integer) {
                int n = this.cbxformat.getSelectedIndex();
                long l = 0L;
                if (n == 1) {
                    l = this.decimalFormatter.getMaximumFractionDigits();
                } else if (n == 2 && this.scientificFormatter instanceof DecimalFormat) {
                    String string2 = ((DecimalFormat)this.scientificFormatter).toPattern();
                    l = 0L;
                    l = string2.indexOf(69) - string2.indexOf(46);
                    if (l > 0L) {
                        --l;
                    }
                }
            }
        } else if (string.equalsIgnoreCase("TEXT_MAPPER")) {
            this.textMapper = object instanceof ColorMapper ? (ColorMapper)object : null;
        } else if (string.equalsIgnoreCase("TEXT_MAPPER_SOURCE")) {
            this.textMapperSource = object instanceof DataSource ? (DataSource)object : null;
        } else if (string.equalsIgnoreCase("DISPLAY_PATTERN") && object instanceof String) {
            this.tfpattern.setText((String)object);
        }
        super.setPropertyValue(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

