/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.data;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jsynoptic.data.ExpressionDataSource;
import jsynoptic.data.VariableAssociation;
import jsynoptic.parser.ExpressionNode;
import jsynoptic.parser.ExpressionParser;
import jsynoptic.parser.ParseException;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.Run;
import jsynoptic.ui.SourceTree;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.DataSourceProvider;
import simtools.data.DuplicateIdException;
import simtools.ui.ResourceFinder;

public class ExpressionDataSourceProvider
implements DataSourceProvider {
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$data$ExpressionDataSourceProvider == null ? (class$jsynoptic$data$ExpressionDataSourceProvider = ExpressionDataSourceProvider.class$("jsynoptic.data.ExpressionDataSourceProvider")) : class$jsynoptic$data$ExpressionDataSourceProvider);
    private boolean conflictsOK = false;
    static /* synthetic */ Class class$jsynoptic$data$ExpressionDataSourceProvider;

    public Object getOptionalInformation(DataSource dataSource, DataSourceCollection dataSourceCollection) {
        if (!(dataSource instanceof ExpressionDataSource)) {
            return null;
        }
        ExpressionDataSource expressionDataSource = (ExpressionDataSource)dataSource;
        Vector<Object> vector = new Vector<Object>();
        vector.add(DataInfo.getLabel(dataSource));
        vector.add(DataInfo.getComment(dataSource));
        Set set = expressionDataSource.getVariables();
        vector.add(new Integer(set.size()));
        Iterator iterator = expressionDataSource.getVariables().iterator();
        while (iterator.hasNext()) {
            VariableAssociation variableAssociation = (VariableAssociation)iterator.next();
            vector.add(DataInfo.getId(variableAssociation.ds));
            vector.add(variableAssociation.var);
        }
        return vector;
    }

    public DataSource provide(String string, String string2, Object object, DataSourcePool dataSourcePool) {
        Object object2;
        Object object3;
        Object object4;
        if (string == null) {
            return null;
        }
        if (!string.startsWith(ExpressionDataSource.EXPRESSION_DATA_SOURCE_MARKER)) {
            return null;
        }
        if (object == null) {
            return null;
        }
        if (!(object instanceof Vector)) {
            return null;
        }
        Vector vector = (Vector)object;
        String string3 = (String)vector.get(0);
        String string4 = (String)vector.get(1);
        int n = (Integer)vector.get(2);
        ConflictListModel conflictListModel = new ConflictListModel();
        if (dataSourcePool != null) {
            for (int i = 0; i < n; ++i) {
                try {
                    object4 = dataSourcePool.getDataSourceWithId((String)vector.get(i * 2 + 3));
                }
                catch (DuplicateIdException duplicateIdException) {
                    object4 = null;
                }
                object3 = (String)vector.get(i * 2 + 4);
                conflictListModel.addElement(new VariableConflict((DataSource)object4, (String)object3));
            }
        }
        if (!conflictListModel.resolved() && JSynoptic.gui != null) {
            this.conflictsOK = false;
            final JList<Object> jList = new JList<Object>(conflictListModel);
            jList.setCellRenderer(new ConflictListCellRenderer());
            object3 = new JPanel(new BorderLayout());
            object2 = new SourceTree();
            ((Container)object3).add((Component)new JScrollPane((Component)object2), "Center");
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            object4 = new JButton(resources.getString("changeSourceAlias"));
            jPanel.add((Component)object4);
            ((Container)object3).add((Component)jPanel, "South");
            JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(jList), (Component)object3);
            ((JTree)object2).setVisibleRowCount(8);
            jList.setVisibleRowCount(10);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            JButton jButton = new JButton("OK");
            jPanel2.add(jButton);
            final JDialog jDialog = new JDialog(JSynoptic.gui, resources.getString("conflictResolutionDialog"), true);
            jDialog.getContentPane().add((Component)jSplitPane, "Center");
            jDialog.getContentPane().add((Component)jPanel2, "South");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExpressionDataSourceProvider.this.conflictsOK = true;
                    jDialog.hide();
                }
            });
            ((AbstractButton)object4).addActionListener(new ActionListener((SourceTree)object2, jList, conflictListModel, jButton){
                private final /* synthetic */ SourceTree val$st;
                private final /* synthetic */ JList val$list;
                private final /* synthetic */ ConflictListModel val$clm;
                private final /* synthetic */ JButton val$bok;
                {
                    this.val$st = sourceTree;
                    this.val$list = jList;
                    this.val$clm = conflictListModel;
                    this.val$bok = jButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = this.val$st.getSelectedSourceOrCollection();
                    if (!(object instanceof DataSource)) {
                        return;
                    }
                    VariableConflict variableConflict = (VariableConflict)this.val$list.getSelectedValue();
                    ((DataSource)object).getInformation().alias = variableConflict.var;
                    this.val$list.repaint();
                    if (this.val$clm.resolved()) {
                        this.val$bok.setEnabled(true);
                    }
                    TreeNode treeNode = (TreeNode)this.val$st.getSelectionPath().getLastPathComponent();
                    ((DefaultTreeModel)this.val$st.getModel()).nodeChanged(treeNode);
                }
            });
            ((JTree)object2).addTreeSelectionListener(new TreeSelectionListener((SourceTree)object2, jList, conflictListModel, jButton){
                private final /* synthetic */ SourceTree val$st;
                private final /* synthetic */ JList val$list;
                private final /* synthetic */ ConflictListModel val$clm;
                private final /* synthetic */ JButton val$bok;
                {
                    this.val$st = sourceTree;
                    this.val$list = jList;
                    this.val$clm = conflictListModel;
                    this.val$bok = jButton;
                }

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object = this.val$st.getSelectedSourceOrCollection();
                    if (object instanceof DataSource && treeSelectionEvent.isAddedPath()) {
                        VariableConflict variableConflict = (VariableConflict)this.val$list.getSelectedValue();
                        variableConflict.ds = (DataSource)object;
                        this.val$list.repaint();
                        if (this.val$clm.resolved()) {
                            this.val$bok.setEnabled(true);
                        }
                        TreeNode treeNode = (TreeNode)this.val$st.getSelectionPath().getLastPathComponent();
                        ((DefaultTreeModel)this.val$st.getModel()).nodeChanged(treeNode);
                    }
                }
            });
            jList.addListSelectionListener(new ListSelectionListener((SourceTree)object2){
                private final /* synthetic */ SourceTree val$st;
                {
                    this.val$st = sourceTree;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Object e = jList.getSelectedValue();
                    if (e == null) {
                        return;
                    }
                    this.val$st.setSelectedValue(((VariableConflict)e).ds);
                }
            });
            jList.setSelectedIndex(0);
            jButton.setEnabled(false);
            jDialog.pack();
            jDialog.show();
            if (!this.conflictsOK) {
                return null;
            }
        }
        ExpressionNode expressionNode = null;
        try {
            object4 = new ExpressionParser(string4);
            for (int i = 0; i < conflictListModel.size(); ++i) {
                object2 = (VariableConflict)conflictListModel.get(i);
                ((ExpressionParser)object4).addVariable(new VariableAssociation(((VariableConflict)object2).ds, ((VariableConflict)object2).var));
            }
            Iterator iterator = Run.plugins.iterator();
            while (iterator.hasNext()) {
                ((ExpressionParser)object4).addClass(iterator.next().getClass());
            }
            expressionNode = ((ExpressionParser)object4).parse();
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(JSynoptic.gui, parseException.getLocalizedMessage(), resources.getString("CantRestoreExpression") + string4, 0);
            return null;
        }
        catch (Error error) {
            JOptionPane.showMessageDialog(JSynoptic.gui, error.getLocalizedMessage(), resources.getString("CantRestoreExpression") + string4, 0);
            return null;
        }
        object4 = new ExpressionDataSource(new DataInfo(string3, string3, string4), expressionNode);
        if (dataSourcePool != null) {
            dataSourcePool.addDataSource((DataSource)object4);
        }
        return object4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ConflictListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            boolean bl3 = ((VariableConflict)jList.getModel().getElementAt(n)).resolved();
            if (bl) {
                if (bl3) {
                    this.setBackground(new Color(0x88FF88));
                } else {
                    this.setBackground(new Color(0xFF8888));
                }
            } else if (bl3) {
                this.setBackground(Color.green);
            } else {
                this.setBackground(Color.red);
            }
            return this;
        }
    }

    protected static class ConflictListModel
    extends DefaultListModel {
        protected ConflictListModel() {
        }

        public boolean resolved() {
            boolean bl = true;
            for (int i = 0; i < this.size(); ++i) {
                bl &= ((VariableConflict)this.get(i)).resolved();
            }
            return bl;
        }
    }

    protected static class VariableConflict {
        public DataSource ds;
        public String var;

        public VariableConflict(DataSource dataSource, String string) {
            this.ds = dataSource;
            this.var = string;
        }

        public String toString() {
            String string = this.var;
            for (int i = this.var.length(); i < 20; ++i) {
                string = string + " ";
            }
            return string;
        }

        public boolean resolved() {
            String string = DataInfo.getAlias(this.ds);
            if (string == null && this.var.equals(DataInfo.getLabel(this.ds))) {
                return true;
            }
            return this.var.equals(string);
        }
    }
}

