/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.async;

import java.io.IOException;
import java.text.ChoiceFormat;
import java.util.AbstractList;
import java.util.Collection;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.UnsupportedOperation;
import simtools.data.async.MultiStampedDataSource;
import simtools.data.async.TimeStampedDataSourceCollection;

public abstract class TimeStampedDataSource
extends DataSource {
    private TimeSource _time;
    private MultiStampedDataSource.LabelSource _label;
    private MultiStampedDataSource.IntegerSource _raw;
    private MultiStampedDataSource.IntegerSource _status;
    private String _name;
    private Double _min = null;
    private Double _max = null;
    private boolean _minmax = false;
    private DataInfo _info = null;
    private final TimeStampedDataSourceCollection _collection;
    protected AuxiliaryCollection _auxiliaries;

    public TimeStampedDataSource(String string, TimeStampedDataSourceCollection timeStampedDataSourceCollection) throws IOException, TimeStampedDataSourceCollection.InvalidFormatException {
        this.setName(string);
        this._collection = timeStampedDataSourceCollection;
        this.setInfo(new DataInfo(string, string, "", ""));
        this.setTime(null);
        this._auxiliaries = new AuxiliaryCollection();
    }

    public abstract double getStart();

    public abstract double getEnd();

    protected abstract void computeMinMax() throws UnsupportedOperation;

    public abstract Object getValue(long var1) throws DataException;

    public abstract double getDoubleValue(long var1) throws DataException;

    public long getStartIndex() throws UnsupportedOperation {
        return 0L;
    }

    public abstract long getLastIndex() throws UnsupportedOperation;

    public double getDoubleMin() throws DataException {
        if (!this.isMinmax()) {
            this.computeMinMax();
        }
        return (Double)this.getMin();
    }

    public double getDoubleMax() throws DataException {
        if (!this.isMinmax()) {
            this.computeMinMax();
        }
        return (Double)this.getMax();
    }

    public String toString() {
        return this.getName();
    }

    public DataInfo getInformation() {
        return this.getInfo();
    }

    public TimeStampedDataSourceCollection getCollection() {
        return this._collection;
    }

    public void setTime(TimeSource timeSource) {
        this._time = timeSource;
    }

    public TimeSource getTime() {
        return this._time;
    }

    void setName(String string) {
        this._name = string;
    }

    protected String getName() {
        return this._name;
    }

    protected void setMinmax(boolean bl) {
        this._minmax = bl;
    }

    boolean isMinmax() {
        return this._minmax;
    }

    void setInfo(DataInfo dataInfo) {
        this._info = dataInfo;
    }

    DataInfo getInfo() {
        return this._info;
    }

    protected void setMin(Double d) {
        this._min = d;
    }

    public Object getMin() {
        return this._min;
    }

    protected void setMax(Double d) {
        this._max = d;
    }

    public Object getMax() {
        return this._max;
    }

    public abstract boolean isValid();

    public Collection getAuxiliarySources() {
        return this._auxiliaries;
    }

    public boolean isCompound() {
        return true;
    }

    public abstract ChoiceFormat getChoiceFormat();

    class AuxiliaryCollection
    extends AbstractList {
        AuxiliaryCollection() {
        }

        public Object get(int n) {
            if (n == 0) {
                return TimeStampedDataSource.this._time;
            }
            return null;
        }

        public int size() {
            return 1;
        }
    }

    public abstract class TimeSource
    extends DataSource {
        public abstract Object getValue(long var1) throws DataException;

        public abstract double getDoubleValue(long var1) throws DataException;

        public long getStartIndex() throws UnsupportedOperation {
            return 0L;
        }

        public long getLastIndex() throws UnsupportedOperation {
            return TimeStampedDataSource.this.getLastIndex();
        }

        public int sortedOrder() {
            return 1;
        }

        public DataInfo getInformation() {
            return new DataInfo("time", TimeStampedDataSource.this.getName() + ".time", "", "");
        }
    }
}

