/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes.test;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import simtools.data.LinearSource;
import simtools.data.SinusSource;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramComponent;
import simtools.shapes.AxisShape;
import simtools.shapes.BasicShape;
import simtools.shapes.CurveShape;
import simtools.shapes.LabelShape;
import simtools.shapes.PlotShape;
import simtools.shapes.ShapesContainer;
import simtools.shapes.ShapesContainerPopup;
import simtools.ui.DesktopCardPanel;
import simtools.ui.DesktopCardPanelListener;

public class TestFrame
extends JFrame
implements ActionListener {
    private static Font _sFont = new Font("TimesRoman", 0, 10);
    public DesktopCardPanel _editorPanel = new DesktopCardPanel(true);
    private JButton _bPrint;
    private JButton _bAdjust;
    private JButton _bAlign;
    private JButton _bUndo;
    private JButton _bRedo;
    private JComboBox _cbZoom;
    private JComboBox _cbGrid;
    private JCheckBox _cbGridDisplay;
    private JPopupMenu _popup;

    public TestFrame() {
        super("DesktopCardPanel Test");
        this.getContentPane().add("Center", this._editorPanel);
        this.getContentPane().add("North", this.createToolBar());
        this.setJMenuBar(this.createMenuBar());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this._popup = new ShapesContainerPopup(null){

            protected void addItems() {
                this._miGroup = new JMenuItem("Group");
                this.add(this._miGroup);
                this._miUnGroup = new JMenuItem("UnGroup");
                this.add(this._miUnGroup);
                this._miReGroup = new JMenuItem("ReGroup");
                this.add(this._miReGroup);
                this._miGroup.addActionListener(this);
                this._miUnGroup.addActionListener(this);
                this._miReGroup.addActionListener(this);
            }

            public void show(Component component, int n, int n2) {
                if (this._miGroup == null) {
                    this.addItems();
                }
                super.show(component, n, n2);
            }
        };
        ShapesContainer shapesContainer = new ShapesContainer("labels");
        shapesContainer.getComponent().setPopupMenu(this._popup);
        for (int i = 0; i < 9; ++i) {
            int n = i / 3;
            int n2 = 4 * n + i % 3;
            LabelShape labelShape = new LabelShape("qqqjjj", 50 * (i + 1), 50, n2, true);
            labelShape.setBounds(_sFont);
            shapesContainer.addElement(labelShape);
            labelShape = new LabelShape("ABCD", 50 * (i + 1), 100, n2, false);
            labelShape.setBounds(_sFont);
            shapesContainer.addElement(labelShape);
        }
        this._editorPanel.addComponent(shapesContainer.getComponent());
        shapesContainer = new ShapesContainer("axes");
        shapesContainer.getComponent().setPopupMenu(this._popup);
        AxisShape axisShape = new AxisShape(true, true, 50, 350, 400, 300);
        shapesContainer.addElement(axisShape);
        axisShape = new AxisShape(false, true, 50, 350, 400, 300);
        axisShape.setWithGridlines(false);
        axisShape.set(0.0, 20.5, 1.0);
        shapesContainer.addElement(axisShape);
        axisShape = new AxisShape(true, true, 50, 750, 400, 300);
        axisShape.setLabel("Value");
        shapesContainer.addElement(axisShape);
        axisShape = new AxisShape(false, true, 50, 750, 400, 300);
        axisShape.setWithGridlines(false);
        axisShape.set(0.0, 20.5, 1.0);
        axisShape.setLabel("Time");
        shapesContainer.addElement(axisShape);
        axisShape = new AxisShape(false, false, 500, 400, 400, 300);
        axisShape.setWithGridlines(false);
        axisShape.set(0.0, 20.5, 1.0);
        axisShape.setLabel("X");
        shapesContainer.addElement(axisShape);
        axisShape = new AxisShape(true, false, 500, 400, 400, 300);
        axisShape.setLabel("Y");
        shapesContainer.addElement(axisShape);
        this._editorPanel.addComponent(shapesContainer.getComponent());
        shapesContainer = new ShapesContainer("plots");
        shapesContainer.getComponent().setPopupMenu(this._popup);
        PlotShape plotShape = new PlotShape(50, 300, 400, 200);
        plotShape.set(0.0, 10.0, 2.0, true, false);
        plotShape.set(-3.0, 5.0, 1.0, false, false);
        CurveShape curveShape = new CurveShape();
        LinearSource linearSource = new LinearSource(0.0, 0.1, 0L, 100L);
        LinearSource linearSource2 = new LinearSource(-1.0, 0.03, 0L, 100L);
        curveShape.setData(linearSource, linearSource2);
        plotShape.insertCurve(curveShape, false, false, -1);
        plotShape.setCurveColor(curveShape, Color.blue);
        curveShape = new CurveShape();
        SinusSource sinusSource = new SinusSource(0.1, 0.2, 2.0, 0.5, 0L, 100L);
        curveShape.setData(linearSource, sinusSource);
        plotShape.insertCurve(curveShape, false, false, -1);
        plotShape.setCurveColor(curveShape, Color.green);
        shapesContainer.addElement(plotShape);
        plotShape = new PlotShape(500, 300, 400, 200);
        plotShape.set(0.0, 4.0, 1.0, true, false);
        plotShape.set(-1.0, 2.0, 1.0, false, false);
        plotShape.insertCurve(curveShape, false, false, -1);
        plotShape.setSecondaryAxis(true, true);
        plotShape.setSecondaryAxis(false, true);
        plotShape.set(0.0, 4.0, 1.0, true, true);
        plotShape.set(-2.0, 4.0, 1.0, false, true);
        plotShape.insertCurve(curveShape, true, true, -1);
        plotShape.setCurveColor(curveShape, Color.pink);
        shapesContainer.addElement(plotShape);
        plotShape = new PlotShape(50, 700, 500, 300);
        plotShape.set(-2.5, 2.5, 0.5, true, false);
        plotShape.set(-1.5, 1.5, 0.5, false, false);
        curveShape = new CurveShape();
        curveShape.setData(new SinusSource(0.03, 0.0, 2.5, 0.0, 0L, 500L), new SinusSource(0.08, 0.0, 1.5, 0.0, 0L, 500L));
        plotShape.insertCurve(curveShape, false, false, -1);
        plotShape.setCurveColor(curveShape, Color.red);
        shapesContainer.addElement(plotShape);
        this._editorPanel.addComponent(shapesContainer.getComponent());
        shapesContainer = new ShapesContainer("basic");
        shapesContainer.getComponent().setPopupMenu(this._popup);
        BasicShape basicShape = new BasicShape(1, 10, 20, 15, 30, 0.0, 0.0);
        basicShape.setBorderColor(Color.blue);
        shapesContainer.addElement(basicShape);
        basicShape = new BasicShape(2, 50, 20, 15, 30, 0.0, 0.0);
        basicShape.setFillerColor(Color.blue);
        shapesContainer.addElement(basicShape);
        basicShape = new BasicShape(3, 110, 20, 15, 30, 30.0, 200.0);
        basicShape.setBorderColor(Color.red);
        basicShape.setFillerColor(Color.blue);
        shapesContainer.addElement(basicShape);
        basicShape = new BasicShape(4, 160, 20, 15, 30, 5.0, 8.0);
        basicShape.setBorderColor(Color.green);
        basicShape.setFillerColor(Color.red);
        shapesContainer.addElement(basicShape);
        this._editorPanel.addComponent(shapesContainer.getComponent());
        this._editorPanel.addListener(new DesktopCardPanelListener(){

            public void componentSelected(JComponent jComponent) {
                TestFrame.this._bUndo.setAction(TestFrame.this.getDiagram().getUndoHandler().getUndoAction());
                TestFrame.this._bRedo.setAction(TestFrame.this.getDiagram().getUndoHandler().getRedoAction());
            }
        });
        this._editorPanel.selectComponent(this._editorPanel.getComponentAt(0));
        DiagramClipboard.create();
        this.pack();
        this.show();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this._editorPanel.createMenu(null));
        return jMenuBar;
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMargin(new Insets(1, 1, 1, 1));
        this._bPrint = new JButton("Print");
        this._bPrint.addActionListener(this);
        jToolBar.add(this._bPrint);
        this._bAdjust = new JButton("Adjust");
        this._bAdjust.addActionListener(this);
        jToolBar.add(this._bAdjust);
        this._bAlign = new JButton("Align");
        this._bAlign.addActionListener(this);
        jToolBar.add(this._bAlign);
        this._bUndo = new JButton("Undo");
        this._bUndo.setEnabled(false);
        this._bUndo.addActionListener(this);
        jToolBar.add(this._bUndo);
        this._bRedo = new JButton("Redo");
        this._bRedo.setEnabled(false);
        this._bRedo.addActionListener(this);
        jToolBar.add(this._bRedo);
        JLabel jLabel = new JLabel("Zoom", 4);
        jLabel.setAlignmentY(0.0f);
        jToolBar.add(jLabel);
        this._cbZoom = new JComboBox();
        this._cbZoom.setAlignmentY(0.0f);
        this._cbZoom.addItem("500%");
        this._cbZoom.addItem("200%");
        this._cbZoom.addItem("150%");
        this._cbZoom.addItem("100%");
        this._cbZoom.addItem("75%");
        this._cbZoom.addItem("50%");
        this._cbZoom.addItem("25%");
        this._cbZoom.addItem("10%");
        this._cbZoom.setSelectedItem("100%");
        this._cbZoom.setEditable(true);
        this._cbZoom.addActionListener(this);
        jToolBar.add(this._cbZoom);
        JLabel jLabel2 = new JLabel("Grid", 4);
        jLabel2.setAlignmentY(0.0f);
        jToolBar.add(jLabel2);
        this._cbGrid = new JComboBox();
        this._cbGrid.setAlignmentY(0.0f);
        this._cbGrid.addItem("0");
        this._cbGrid.addItem("5");
        this._cbGrid.addItem("10");
        this._cbGrid.addItem("20");
        this._cbGrid.addItem("40");
        this._cbGrid.setSelectedItem("0");
        this._cbGrid.setEditable(true);
        this._cbGrid.addActionListener(this);
        jToolBar.add(this._cbGrid);
        this._cbGridDisplay = new JCheckBox("Grid Display");
        this._cbGridDisplay.addActionListener(this);
        jToolBar.add(this._cbGridDisplay);
        return jToolBar;
    }

    private double getZoomValue() {
        try {
            String string = (String)this._cbZoom.getSelectedItem();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            }
            Double d = new Double(string);
            return d / 100.0;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    private DiagramComponent getDiagram() {
        JComponent jComponent = this._editorPanel.getSelectedComponent();
        if (jComponent instanceof DiagramComponent) {
            return (DiagramComponent)jComponent;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._bPrint) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            printerJob.setPrintable(diagramComponent);
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (actionEvent.getSource() == this._bAdjust) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.adjust();
        } else if (actionEvent.getSource() == this._bAlign) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.align();
        } else if (actionEvent.getSource() == this._cbZoom) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.setZoom(this.getZoomValue());
        } else if (actionEvent.getSource() == this._cbGridDisplay) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.setGridDisplay(this._cbGridDisplay.isSelected());
        } else if (actionEvent.getSource() == this._cbGrid) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            try {
                String string = (String)this._cbGrid.getSelectedItem();
                Integer n = new Integer(string);
                diagramComponent.setGrid(n);
            }
            catch (Exception exception) {
                diagramComponent.setGrid(0);
            }
        } else if (actionEvent.getSource() == this._bUndo || actionEvent.getSource() == this._bRedo) {
            this.repaint();
        }
    }

    public static void main(String[] stringArray) {
        final TestFrame testFrame = new TestFrame();
        Thread thread = new Thread(){

            public void run() {
                try {
                    4.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TestFrame testFrame2 = (TestFrame)testFrame;
                String string = testFrame2._editorPanel.getSelectedComponent().getName();
                testFrame2._editorPanel.getSelectedComponent().setName(string + "*");
                testFrame2._editorPanel.updateComponentName(testFrame2._editorPanel.getSelectedComponent());
            }
        };
        thread.start();
    }
}

