/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.DataSourcePoolEvent;
import simtools.data.DataSourcePoolListener;

public class SourceTree
extends JTree
implements DataSourcePoolListener,
ActionListener {
    protected DataSourcePool pool;
    protected DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    protected DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    protected JMenuItem sourceInfo;
    protected double actionX;
    protected double actionY;
    static /* synthetic */ Class class$simtools$data$DataSource;
    static /* synthetic */ Class class$simtools$data$DataSourceCollection;

    public SourceTree(DataSourcePool dataSourcePool) {
        this.setModel(this.treeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.pool = dataSourcePool;
        dataSourcePool.addListener(this);
        Object object = dataSourcePool.dataSources().iterator();
        while (object.hasNext()) {
            this.addSource((DataSource)object.next());
        }
        object = dataSourcePool.dataSourceCollections().iterator();
        while (object.hasNext()) {
            this.addCollection((DataSourceCollection)object.next());
        }
        this.treeModel.reload();
        this.setTransferHandler(new SourceTransferHandler());
        this.setDragEnabled(true);
        this.setCellRenderer(this.createRenderer());
        object = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                if (jComponent != SourceTree.this) {
                    return;
                }
                TreePath treePath = SourceTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if ((mouseEvent.getModifiers() & 4) == 4) {
                    Object object;
                    if (treePath != null) {
                        SourceTree.this.setSelectionPath(treePath);
                    }
                    boolean bl = false;
                    if (SourceTree.this.getSelectionPath() != null && (object = SourceTree.this.getSelectionPath().getLastPathComponent()) instanceof LockableTreeNode && ((LockableTreeNode)object).isLocked()) {
                        bl = true;
                    }
                    if (!bl) {
                        SourceTree.this.doPopup(mouseEvent.getX(), mouseEvent.getY());
                    }
                    return;
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                SourceTree.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.addMouseListener((MouseListener)object);
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Object object;
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                if (jComponent != SourceTree.this) {
                    return;
                }
                TreePath treePath = SourceTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof LockableTreeNode && ((LockableTreeNode)object).isLocked()) {
                    SourceTree.this.setCursor(Cursor.getPredefinedCursor(3));
                    return;
                }
                SourceTree.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.addMouseMotionListener(mouseMotionAdapter);
        this.registerKeyboardAction(this, "d", KeyStroke.getKeyStroke(127, 0), 0);
        this.registerKeyboardAction(this, "d", KeyStroke.getKeyStroke(8, 0), 0);
    }

    public SourceTree() {
        this(DataSourcePool.global);
    }

    public void setSelectedValue(Object object) {
        if (object == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode).getUserObject()) == null || !object2.equals(object)) continue;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.scrollPathToVisible(treePath);
            this.setSelectionPath(treePath);
            return;
        }
    }

    public void setSelectedValueById(String string) {
        if (string == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || !string.equals(DataInfo.getId((defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode).getUserObject()))) continue;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.scrollPathToVisible(treePath);
            this.setSelectionPath(treePath);
            return;
        }
    }

    protected void recursiveLock(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode.getUserObject() == object && defaultMutableTreeNode instanceof LockableTreeNode) {
            ((LockableTreeNode)defaultMutableTreeNode).setLocked(bl);
            return;
        }
        if (!defaultMutableTreeNode.getAllowsChildren()) {
            return;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            this.recursiveLock((DefaultMutableTreeNode)enumeration.nextElement(), object, bl);
        }
    }

    public void lock(Object object) {
        this.recursiveLock(this.rootNode, object, true);
        this.repaint();
    }

    public void unlock(Object object) {
        this.recursiveLock(this.rootNode, object, false);
        this.repaint();
    }

    public boolean isLocked(Object object) {
        return this.recursiveIsLocked(this.rootNode, object);
    }

    protected boolean recursiveIsLocked(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        if (defaultMutableTreeNode == null) {
            return false;
        }
        if (defaultMutableTreeNode.getUserObject() == object && defaultMutableTreeNode instanceof LockableTreeNode) {
            return ((LockableTreeNode)defaultMutableTreeNode).isLocked();
        }
        if (!defaultMutableTreeNode.getAllowsChildren()) {
            return false;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (enumeration == null) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            if (!this.recursiveIsLocked((DefaultMutableTreeNode)enumeration.nextElement(), object)) continue;
            return true;
        }
        return false;
    }

    protected void doPopup(int n, int n2) {
    }

    protected void removeNodesWithUserObject(Object object) {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Object object2 = this.rootNode.children();
        while (object2.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2.nextElement();
            if (defaultMutableTreeNode.getUserObject() != object) continue;
            vector.add(defaultMutableTreeNode);
        }
        object2 = vector.iterator();
        while (object2.hasNext()) {
            this.rootNode.remove((MutableTreeNode)object2.next());
        }
    }

    protected void addSource(DataSource dataSource) {
        if (dataSource.isCompound()) {
            this.treeModel.insertNodeInto(new CompoundSourceNode(dataSource), this.rootNode, this.rootNode.getChildCount());
        } else {
            this.treeModel.insertNodeInto(new SourceNode(dataSource), this.rootNode, this.rootNode.getChildCount());
        }
    }

    protected void addCollection(DataSourceCollection dataSourceCollection) {
        if (dataSourceCollection.isCompound()) {
            this.treeModel.insertNodeInto(new CompoundCollectionNode(dataSourceCollection), this.rootNode, this.rootNode.getChildCount());
        } else {
            this.treeModel.insertNodeInto(new CollectionNode(dataSourceCollection), this.rootNode, this.rootNode.getChildCount());
        }
    }

    protected void changeSource(DataSource dataSource, DataSource dataSource2) {
        Enumeration<TreeNode> enumeration = this.rootNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() != dataSource2) continue;
            ((SourceNode)defaultMutableTreeNode).changeSource(dataSource);
        }
    }

    protected void changeCollection(DataSourceCollection dataSourceCollection, DataSourceCollection dataSourceCollection2) {
        Enumeration<TreeNode> enumeration = this.rootNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() != dataSourceCollection2) continue;
            ((CollectionNode)defaultMutableTreeNode).changeCollection(dataSourceCollection);
        }
    }

    public Object getSelectedSourceOrCollection() {
        if (this.getSelectionPath() == null) {
            return null;
        }
        Object object = this.getSelectionPath().getLastPathComponent();
        if (object == null) {
            return null;
        }
        if (object instanceof SourceNode) {
            return ((SourceNode)object).getUserObject();
        }
        if (object instanceof CollectionNode) {
            return ((CollectionNode)object).getUserObject();
        }
        return null;
    }

    public void dataSourcePoolNotification(DataSourcePoolEvent dataSourcePoolEvent) {
        switch (dataSourcePoolEvent.action) {
            case 9: {
                this.addSource(dataSourcePoolEvent.source);
                break;
            }
            case 17: {
                this.addCollection(dataSourcePoolEvent.collection);
                break;
            }
            case 10: {
                this.removeNodesWithUserObject(dataSourcePoolEvent.source);
                break;
            }
            case 18: {
                this.removeNodesWithUserObject(dataSourcePoolEvent.collection);
                break;
            }
            case 12: {
                this.changeSource(dataSourcePoolEvent.source, dataSourcePoolEvent.oldSource);
                break;
            }
            case 20: {
                this.changeCollection(dataSourcePoolEvent.collection, dataSourcePoolEvent.oldCollection);
            }
        }
        this.reload();
    }

    public void reload() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath treePath = this.getSelectionPath();
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Object object = this.rootNode.children();
        while (object.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
            if (!this.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) continue;
            vector.add(defaultMutableTreeNode);
        }
        this.treeModel.reload();
        object = vector.iterator();
        while (object.hasNext()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)object.next();
            this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
        this.setSelectionPath(treePath);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("d")) {
            Object object = this.getSelectedSourceOrCollection();
            if (object == null) {
                return;
            }
            if (this.isLocked(object)) {
                return;
            }
            if (object instanceof DataSource) {
                this.pool.removeDataSource((DataSource)object);
            } else if (object instanceof DataSourceCollection) {
                this.pool.removeDataSourceCollection((DataSourceCollection)object);
            }
            return;
        }
    }

    protected TreeCellRenderer createRenderer() {
        return new DefaultTreeCellRenderer();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class SourceTransferable
    implements Transferable {
        protected SourceTransferable() {
        }

        public DataFlavor[] getTransferDataFlavors() {
            Object object = SourceTree.this.getSelectionPath().getLastPathComponent();
            if (object == null) {
                return new DataFlavor[0];
            }
            DataFlavor[] dataFlavorArray = new DataFlavor[]{object instanceof SourceNode ? new DataFlavor(class$simtools$data$DataSource == null ? (class$simtools$data$DataSource = SourceTree.class$("simtools.data.DataSource")) : class$simtools$data$DataSource, object.toString()) : (object instanceof CollectionNode ? new DataFlavor(class$simtools$data$DataSourceCollection == null ? (class$simtools$data$DataSourceCollection = SourceTree.class$("simtools.data.DataSourceCollection")) : class$simtools$data$DataSourceCollection, object.toString()) : DataFlavor.stringFlavor)};
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            Object object = SourceTree.this.getSelectionPath().getLastPathComponent();
            if (object == null) {
                return false;
            }
            if (object instanceof SourceNode) {
                return (class$simtools$data$DataSource == null ? (class$simtools$data$DataSource = SourceTree.class$("simtools.data.DataSource")) : class$simtools$data$DataSource).equals(dataFlavor.getRepresentationClass());
            }
            if (object instanceof CollectionNode) {
                return (class$simtools$data$DataSourceCollection == null ? (class$simtools$data$DataSourceCollection = SourceTree.class$("simtools.data.DataSourceCollection")) : class$simtools$data$DataSourceCollection).equals(dataFlavor.getRepresentationClass());
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            Object object = SourceTree.this.getSelectedSourceOrCollection();
            if (object == null) {
                return null;
            }
            if (object instanceof DataSource && (class$simtools$data$DataSource == null ? (class$simtools$data$DataSource = SourceTree.class$("simtools.data.DataSource")) : class$simtools$data$DataSource).equals(dataFlavor.getRepresentationClass())) {
                return object;
            }
            if (object instanceof DataSourceCollection && (class$simtools$data$DataSourceCollection == null ? (class$simtools$data$DataSourceCollection = SourceTree.class$("simtools.data.DataSourceCollection")) : class$simtools$data$DataSourceCollection).equals(dataFlavor.getRepresentationClass())) {
                return object;
            }
            return null;
        }
    }

    protected class SourceTransferHandler
    extends TransferHandler {
        protected SourceTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent != SourceTree.this) {
                return null;
            }
            return new SourceTransferable();
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    protected class CompoundCollectionNode
    extends CollectionNode {
        CompoundCollectionNode(DataSourceCollection dataSourceCollection) {
            super((Object)dataSourceCollection);
            this.setChildNodes(dataSourceCollection.getCollectionContainers().iterator());
        }

        CompoundCollectionNode(DataSourceCollection.Container container) {
            super(container);
            Collection collection = container.getChildren();
            if (collection != null) {
                this.setChildNodes(collection.iterator());
            }
        }

        public String toString() {
            if (this.userObject instanceof DataSourceCollection.Container) {
                return this.userObject.toString();
            }
            return super.toString();
        }

        private void removeAllChildrenRecursively() {
            Enumeration<TreeNode> enumeration = this.children();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = enumeration.nextElement();
                    if (!(treeNode instanceof CompoundCollectionNode)) continue;
                    ((CompoundCollectionNode)treeNode).removeAllChildrenRecursively();
                }
            }
            this.removeAllChildren();
        }

        public void changeCollection(DataSourceCollection dataSourceCollection) {
            this.removeAllChildrenRecursively();
            this.setUserObject(dataSourceCollection);
            this.setChildNodes(dataSourceCollection.getCollectionContainers().iterator());
        }

        protected void setChildNodes(Iterator iterator) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof DataSourceCollection.Container) {
                    this.add(new CompoundCollectionNode((DataSourceCollection.Container)e));
                    continue;
                }
                this.addDataSource((DataSource)e);
            }
        }

        public boolean isLocked() {
            Enumeration<TreeNode> enumeration = this.children();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = enumeration.nextElement();
                    if (!(treeNode instanceof CompoundCollectionNode ? ((CompoundCollectionNode)treeNode).isLocked() : treeNode instanceof LockableTreeNode && ((LockableTreeNode)treeNode).getLocked())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    protected class CollectionNode
    extends LockableTreeNode {
        CollectionNode(Object object) {
            super(object, true);
        }

        CollectionNode(DataSourceCollection dataSourceCollection) {
            this((Object)dataSourceCollection);
            this.setSourceNodes(dataSourceCollection.iterator());
        }

        public String toString() {
            if (this.userObject == null) {
                return "DataSourceCollection";
            }
            String string = DataInfo.getLabel((DataSourceCollection)this.userObject);
            if (string != null) {
                return string;
            }
            string = this.userObject.getClass().getName();
            int n = string.lastIndexOf(".");
            if (n != -1) {
                return string.substring(n + 1);
            }
            return string;
        }

        public void changeCollection(DataSourceCollection dataSourceCollection) {
            this.removeAllChildren();
            this.setUserObject(dataSourceCollection);
            this.setSourceNodes(dataSourceCollection.iterator());
        }

        protected void setSourceNodes(Iterator iterator) {
            while (iterator.hasNext()) {
                this.addDataSource((DataSource)iterator.next());
            }
        }

        protected void addDataSource(DataSource dataSource) {
            if (dataSource.isCompound()) {
                this.add(new CompoundSourceNode(dataSource));
            } else {
                this.add(new SourceNode(dataSource));
            }
        }

        public boolean isLocked() {
            Enumeration<TreeNode> enumeration = this.children();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = enumeration.nextElement();
                    if (!(treeNode instanceof LockableTreeNode) || !((LockableTreeNode)treeNode).getLocked()) continue;
                    return true;
                }
            }
            return super.isLocked();
        }
    }

    protected class CompoundSourceNode
    extends SourceNode {
        CompoundSourceNode(DataSource dataSource) {
            super(dataSource, true);
            Iterator iterator = dataSource.getAuxiliarySources().iterator();
            while (iterator.hasNext()) {
                this.add(new SourceNode((DataSource)iterator.next()));
            }
        }

        public void changeSource(DataSource dataSource) {
            super.changeSource(dataSource);
            this.removeAllChildren();
            Iterator iterator = dataSource.getAuxiliarySources().iterator();
            while (iterator.hasNext()) {
                this.add(new SourceNode((DataSource)iterator.next()));
            }
        }

        public boolean isLocked() {
            Enumeration<TreeNode> enumeration = this.children();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = enumeration.nextElement();
                    if (!(treeNode instanceof LockableTreeNode) || !((LockableTreeNode)treeNode).getLocked()) continue;
                    return true;
                }
            }
            return super.isLocked();
        }
    }

    protected class SourceNode
    extends LockableTreeNode {
        SourceNode(DataSource dataSource) {
            super(dataSource, false);
        }

        SourceNode(DataSource dataSource, boolean bl) {
            super(dataSource, bl);
        }

        public String toString() {
            if (this.userObject == null) {
                return "DataSource";
            }
            String string = DataInfo.toString((DataSource)this.userObject);
            if (string != null) {
                return string;
            }
            string = this.userObject.getClass().getName();
            int n = string.lastIndexOf(".");
            if (n != -1) {
                return string.substring(n + 1);
            }
            return string;
        }

        public void changeSource(DataSource dataSource) {
            this.setUserObject(dataSource);
        }
    }

    protected class LockableTreeNode
    extends DefaultMutableTreeNode {
        boolean locked;

        LockableTreeNode(Object object, boolean bl) {
            super(object, bl);
            this.setLocked(false);
        }

        public void setLocked(boolean bl) {
            this.locked = bl;
        }

        public boolean getLocked() {
            return this.locked;
        }

        public boolean isLocked() {
            if (this.locked) {
                return true;
            }
            TreeNode treeNode = this.getParent();
            if (treeNode == null) {
                return false;
            }
            if (treeNode instanceof LockableTreeNode) {
                return ((LockableTreeNode)treeNode).isLocked();
            }
            return false;
        }
    }
}

