/* $Id: SpecProvider.java,v 1.1 2005/03/31 05:40:03 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : 
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : Consumer
 * 
 * -----------------------------------------------------------------------
 */


package tsp.consumer.util.configuration;

import tsp.util.ToStringHelper;

public class SpecProvider implements Consolidatable{

    private String name;
    private String url;
    private Integer implicitPeriod;
    private String description;
    private SpecProviderList providerList;
    private final SpecSamplingConfig root;

    public SpecProvider(final SpecSamplingConfig root) {
		super();
		this.root = root;
	}
    
    public SpecProviderList getProviderList() {
        return providerList;
    }

    void setProviderList(SpecProviderList providerList) {
        this.providerList = providerList;
        providerList.getProviders().add(this);
    }


    public String getName() {
        return name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public Integer getImplicitPeriod() {
        return implicitPeriod;
    }

    void setImplicitPeriod(Integer implicitPeriod) {
        this.implicitPeriod = implicitPeriod;
    }

    public String getDescription() {
        return description;
    }

    void setDescription(String description) {
        this.description = description;
    }

     public String toString(){
        return ToStringHelper.toString(this);
    }
     
     public void consolidate() throws SpecException {
		// NOP
	}
}
