/* $Id: NameSpaceSorterTest.java,v 1.1 2005/04/09 03:35:04 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;

import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;
import junit.framework.TestCase;

public class NameSpaceSorterTest extends TestCase{
	
	
	private TspSimpleSampleSymbolInfo[] infos = {
			new TspSimpleSampleSymbolInfo("n1::n1s1", 10, 20, 30),
			new TspSimpleSampleSymbolInfo("n1::n1s2", 10, 20, 30),
			new TspSimpleSampleSymbolInfo("n2::n2s1", 10, 20, 30),
			new TspSimpleSampleSymbolInfo("n2::n2s2", 10, 20, 30),
			new TspSimpleSampleSymbolInfo("n3::n3s1", 10, 20, 30),
	};
	
	public void testGetSampleInfoByNamespace() throws Exception{ 
		NamespaceSorter sorter = new NamespaceSorter(infos);
		assertNull(sorter.getSampleInfoByNamespace("blabla"));
		
		TspSimpleSampleSymbolInfo[] n2Infos = sorter.getSampleInfoByNamespace("n2");
		assertNotNull(n2Infos);
		assertEquals("n2s1", n2Infos[0].getName());
		assertEquals("n2s2", n2Infos[1].getName());
	}
	
	public void testGetIndexInInitialArray() throws Exception{
		NamespaceSorter sorter = new NamespaceSorter(infos);
		assertEquals(3, sorter.getIndexInInitialArray("n2::n2s2"));
		
		try{
			sorter.getIndexInInitialArray("blabla");
			fail("Exception expected");
		}catch(TspConsumerException e ){
			assertEquals("tsp.core.consumer.TspConsumerException: Unable to find symbol 'blabla' in initial array", e.toString());
		}
	}
	
}







