SET(XSCRIPT_OUTPUT_PATH ${CMAKE_BINARY_DIR}/bin)
MAKE_DIRECTORY(${XSCRIPT_OUTPUT_PATH})
# define TSP_XSCRIPT MACRO
MACRO(TSP_XSCRIPT)
  FOREACH(SCRIPT_FILE ${ARGV})
    GET_FILENAME_COMPONENT(FN ${SCRIPT_FILE} NAME)
    CONFIGURE_FILE(${SCRIPT_FILE} ${XSCRIPT_OUTPUT_PATH}/${FN} COPYONLY)
    INSTALL(
      PROGRAMS ${XSCRIPT_OUTPUT_PATH}/${FN}
      DESTINATION bin COMPONENT Runtime)
  ENDFOREACH(SCRIPT_FILE)
ENDMACRO(TSP_XSCRIPT)

SET(TSP_SHARE_BASEDIR share/tsp)

SET(XINCLUDE_OUTPUT_PATH ${CMAKE_BINARY_DIR}/${CMAKE_SYSTEM_NAME}/${CMAKE_BUILD_TYPE}/include)
MAKE_DIRECTORY(${XINCLUDE_OUTPUT_PATH})
# define TSP_XINCLUDE MACRO
MACRO(TSP_XINCLUDE)
  SET (TSP_XINCLUDE_DIR_FOUND "YES")
  SET (INCLUDE_DIR "/tsp" )
  FOREACH(INCLUDE_FILE ${ARGV})
	IF (INCLUDE_FILE STREQUAL "DIRECTORY")
		SET (TSP_XINCLUDE_DIR_FOUND "NO")
	ENDIF (INCLUDE_FILE STREQUAL "DIRECTORY")	
	
	IF (TSP_XINCLUDE_DIR_FOUND)
		# handle missing extension
		IF (NOT "${INCLUDE_FILE}" MATCHES ".h" AND NOT "${INCLUDE_FILE}" MATCHES ".H")
			SET(INCLUDE_FILE ${INCLUDE_FILE}.h)
		ENDIF ( NOT "${INCLUDE_FILE}" MATCHES ".h" AND NOT "${INCLUDE_FILE}" MATCHES ".H") 
		GET_FILENAME_COMPONENT(FN ${INCLUDE_FILE} NAME)
		CONFIGURE_FILE(${INCLUDE_FILE} ${XINCLUDE_OUTPUT_PATH}${INCLUDE_DIR}/${FN} COPYONLY)
		INSTALL(FILES ${XINCLUDE_OUTPUT_PATH}${INCLUDE_DIR}/${FN}
		  DESTINATION include${INCLUDE_DIR}
		  COMPONENT Development)
		#INSTALL_FILES(/include${INCLUDE_DIR} .h ${XINCLUDE_OUTPUT_PATH}${INCLUDE_DIR}/${FN})
	ELSE (TSP_XINCLUDE_DIR_FOUND)
		IF (NOT INCLUDE_FILE STREQUAL "DIRECTORY")
			SET (INCLUDE_DIR /${INCLUDE_FILE})
			SET (TSP_XINCLUDE_DIR_FOUND "YES")
		ENDIF (NOT INCLUDE_FILE STREQUAL "DIRECTORY")
	ENDIF (TSP_XINCLUDE_DIR_FOUND)
  ENDFOREACH(INCLUDE_FILE)
ENDMACRO(TSP_XINCLUDE)

MACRO(TSP_CONFIGURE_FILE_AUTOTOOLS_COMPAT)
  SET(configure_input "${ARGV1} generated from ${ARGV0} by CMake.")
  CONFIGURE_FILE(${ARGV})
ENDMACRO(TSP_CONFIGURE_FILE_AUTOTOOLS_COMPAT)

MACRO(TSP_PROGRAM_INSTALL)
  INSTALL(
    TARGETS ${ARGV}
    DESTINATION bin COMPONENT Runtime)
  IF (WIN32 AND CMAKE_BUILD_TYPE STREQUAL "Debug")
	FOREACH(SCRIPT_FILE ${ARGV})
		INSTALL(FILES ${EXECUTABLE_OUTPUT_PATH}/${CMAKE_BUILD_TYPE}/${SCRIPT_FILE}.pdb 
				DESTINATION bin COMPONENT Development)
	ENDFOREACH(SCRIPT_FILE)
  ENDIF (WIN32 AND CMAKE_BUILD_TYPE STREQUAL "Debug")
ENDMACRO(TSP_PROGRAM_INSTALL)

MACRO(TSP_LIBRARY_INSTALL)
  INSTALL(
    TARGETS ${ARGV}
    RUNTIME DESTINATION bin COMPONENT Runtime
    LIBRARY DESTINATION lib COMPONENT Runtime
    ARCHIVE DESTINATION lib COMPONENT Development
    )
  IF (WIN32 AND CMAKE_BUILD_TYPE STREQUAL "Debug")
	FOREACH(SCRIPT_FILE ${ARGV})
		INSTALL(FILES ${LIBRARY_OUTPUT_PATH}/${CMAKE_BUILD_TYPE}/${SCRIPT_FILE}.pdb 
				DESTINATION bin COMPONENT Development)
	ENDFOREACH(SCRIPT_FILE)
  ENDIF (WIN32 AND CMAKE_BUILD_TYPE STREQUAL "Debug")
ENDMACRO(TSP_LIBRARY_INSTALL)

MARK_AS_ADVANCED(
  XSCRIPT_OUTPUT_PATH
  XINCLUDE_OUTPUT_PATH
  )

MESSAGE(STATUS "TSP CMake Tools loaded.")
